/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.EmiNameWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import shims.java.com.unascribed.retroemi.REMIScreen;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.Element;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.ButtonWidget;
import shims.java.net.minecraft.text.Text;

public class ConfigEnumScreen<T>
extends REMIScreen {
    private final ConfigScreen last;
    private final List<Entry<T>> entries;
    private final Consumer<T> selection;
    private ListWidget list;

    public ConfigEnumScreen(ConfigScreen last, List<Entry<T>> entries, Consumer<T> selection) {
        super(EmiPort.translatable("screen.emi.config"));
        this.last = last;
        this.entries = entries;
        this.selection = selection;
    }

    @Override
    public void init() {
        super.init();
        this.addDrawable(new EmiNameWidget(this.width / 2, 16));
        int w = 200;
        int x = (this.width - w) / 2;
        this.addDrawableChild(EmiPort.newButton(x, this.height - 30, w, 20, EmiPort.translatable("gui.done"), button -> this.close()));
        this.list = new ListWidget(this.client, this.width, this.height, 40, this.height - 40);
        for (Entry<T> e : this.entries) {
            this.list.addEntry(new SelectionWidget<T>(this, e));
        }
        this.addSelectableChild(this.list);
    }

    @Override
    public void render(DrawContext raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.renderBackgroundTexture(context.raw());
        this.list.render(context.raw(), mouseX, mouseY, delta);
        super.render(context.raw(), mouseX, mouseY, delta);
        ListWidget.Entry entry = this.list.getHoveredEntry();
        if (entry instanceof SelectionWidget) {
            SelectionWidget widget = (SelectionWidget)entry;
            if (widget.button.isHovered()) {
                EmiRenderHelper.drawTooltip(this, context, widget.tooltip, mouseX, mouseY);
            }
        }
    }

    @Override
    public void close() {
        Minecraft.getMinecraft().displayGuiScreen((GuiScreen)this.last);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 1) {
            this.close();
            return true;
        }
        if (this.client.gameSettings.keyBindInventory.keyCode == keyCode) {
            this.close();
            return true;
        }
        if (keyCode == 15) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public record Entry<T>(T value, Text name, List<TooltipComponent> tooltip) {
    }

    public static class SelectionWidget<T>
    extends ListWidget.Entry {
        private final ButtonWidget button;
        private final List<TooltipComponent> tooltip;

        public SelectionWidget(ConfigEnumScreen<T> screen, Entry<T> e) {
            this.button = EmiPort.newButton(0, 0, 200, 20, e.name(), t -> {
                screen.selection.accept(e.value());
                screen.close();
            });
            this.tooltip = e.tooltip();
        }

        @Override
        public List<? extends Element> children() {
            return List.of(this.button);
        }

        @Override
        public void render(DrawContext raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.y = y;
            this.button.x = x + width / 2 - this.button.getWidth() / 2;
            this.button.render(raw, mouseX, mouseY, delta);
        }

        @Override
        public int getHeight() {
            return 20;
        }
    }
}

