/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiLog;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import shims.java.net.minecraft.text.ClickEvent;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.Style;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Util;

public class EmiScreenshotRecorder {
    private static final String SCREENSHOTS_DIRNAME = "screenshots";

    public static void saveScreenshot(String path, int width, int height, Runnable renderer) {
        EmiScreenshotRecorder.saveScreenshotInner(path, width, height, renderer);
    }

    private static void saveScreenshotInner(String path, int width, int height, Runnable renderer) {
        Minecraft client = Minecraft.getMinecraft();
        int scale = EmiConfig.recipeScreenshotScale < 1 ? EmiPort.getGuiScale(client) : EmiConfig.recipeScreenshotScale;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glPushAttrib((int)6144);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)(width * scale), (int)(height * scale));
        GL11.glDisable((int)2929);
        renderer.run();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glEnable((int)2929);
        BufferedImage framebuffer = EmiScreenshotRecorder.takeScreenshot(width * scale, height * scale);
        EmiScreenshotRecorder.saveScreenshotInner(client.mcDataDir, path, framebuffer, (Text message) -> client.ingameGUI.getChatGUI().printChatMessage(message.toString()));
    }

    private static void saveScreenshotInner(File gameDirectory, String suggestedPath, BufferedImage framebuffer, Consumer<Text> messageReceiver) {
        File screenshots = new File(gameDirectory, SCREENSHOTS_DIRNAME);
        screenshots.mkdir();
        String filename = EmiScreenshotRecorder.getScreenshotFilename(screenshots, suggestedPath);
        File file = new File(screenshots, filename);
        File parent = file.getParentFile();
        parent.mkdirs();
        Util.getIoWorkerExecutor().execute(() -> {
            try {
                ImageIO.write((RenderedImage)framebuffer, "png", file);
                MutableText text = EmiPort.literal(filename, Style.EMPTY.withUnderline(true).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
                messageReceiver.accept(EmiPort.translatable("screenshot.success", text));
            }
            catch (Throwable e) {
                EmiLog.error("Failed to write screenshot");
                EmiLog.error(e.getMessage());
                messageReceiver.accept(EmiPort.translatable("screenshot.failure", e.getMessage()));
            }
        });
    }

    private static BufferedImage takeScreenshot(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (y * width + x) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                data[(height - 1 - y) * width + x] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return image;
    }

    private static String getScreenshotFilename(File directory, String path) {
        int i = 1;
        while (new File(directory, path + (String)(i == 1 ? "" : "_" + i) + ".png").exists()) {
            ++i;
        }
        return path + (String)(i == 1 ? "" : "_" + i) + ".png";
    }
}

