/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.registry.EmiDragDropHandlers;
import dev.emi.emi.registry.EmiExclusionAreas;
import dev.emi.emi.registry.EmiIngredientSerializers;
import dev.emi.emi.registry.EmiPluginContainer;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.registry.EmiRegistryImpl;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.registry.EmiStackProviders;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiPersistentData;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.EmiSearch;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Consumer;
import moddedmite.emi.util.MinecraftServerHelper;
import shims.java.net.minecraft.text.Text;

public class EmiReloadManager {
    private static int loadedResourcesMask = 0;
    private static volatile boolean clear = false;
    private static volatile boolean restart = false;
    private static volatile int status = 0;
    private static Thread thread;
    public static volatile Text reloadStep;
    public static volatile long reloadWorry;

    public static void reloadTags() {
        if ((loadedResourcesMask |= 1) == 3) {
            EmiLog.info("Recipes synchronized, reloading EMI");
            loadedResourcesMask = 0;
            EmiReloadManager.reload();
        } else {
            EmiLog.info("Recipes synchronized, waiting for tags to reload EMI...");
        }
    }

    public static void reloadRecipes() {
        if ((loadedResourcesMask |= 2) == 3) {
            EmiLog.info("Tags synchronized, reloading EMI");
            loadedResourcesMask = 0;
            EmiReloadManager.reload();
        } else {
            EmiLog.info("Tags synchronized, waiting for recipes to reload EMI...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Class<EmiReloadManager> clazz = EmiReloadManager.class;
        synchronized (EmiReloadManager.class) {
            loadedResourcesMask = 0;
            clear = true;
            status = 0;
            reloadWorry = Long.MAX_VALUE;
            if (thread != null && thread.isAlive()) {
                restart = true;
            } else {
                thread = new Thread(new ReloadWorker());
                thread.setDaemon(true);
                thread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Class<EmiReloadManager> clazz = EmiReloadManager.class;
        synchronized (EmiReloadManager.class) {
            EmiReloadManager.step(EmiPort.literal("Starting Reload"));
            status = 1;
            if (thread != null && thread.isAlive()) {
                restart = true;
            } else {
                clear = false;
                thread = new Thread(new ReloadWorker());
                thread.setDaemon(false);
                thread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void step(Text text) {
        EmiReloadManager.step(text, 5000L);
    }

    public static void step(Text text, long worry) {
        reloadStep = text;
        reloadWorry = System.currentTimeMillis() + worry;
    }

    public static boolean isLoaded() {
        return status == 2 && (thread == null || !thread.isAlive());
    }

    public static int getStatus() {
        return status;
    }

    static {
        reloadStep = EmiPort.literal("");
        reloadWorry = Long.MAX_VALUE;
    }

    private static class ReloadWorker
    implements Runnable {
        private ReloadWorker() {
        }

        @Override
        public void run() {
            int retries = 3;
            block6: do {
                try {
                    if (!clear) {
                        EmiLog.info("Starting EMI reload...");
                    }
                    long reloadStart = System.currentTimeMillis();
                    restart = false;
                    EmiReloadManager.step(EmiPort.literal("Clearing data"));
                    EmiRecipes.clear();
                    EmiStackList.clear();
                    EmiIngredientSerializers.clear();
                    EmiExclusionAreas.clear();
                    EmiDragDropHandlers.clear();
                    EmiStackProviders.clear();
                    EmiRecipeFiller.clear();
                    EmiHidden.clear();
                    if (clear) {
                        clear = false;
                        continue;
                    }
                    EmiReloadManager.step(EmiPort.literal("Processing tags"));
                    EmiTags.reload();
                    EmiReloadManager.step(EmiPort.literal("Constructing index"));
                    EmiComparisonDefaults.comparisons = new HashMap<Object, Comparison>();
                    EmiStackList.reload();
                    if (restart) continue;
                    EmiRegistryImpl registry = new EmiRegistryImpl();
                    ArrayList plugins = Lists.newArrayList();
                    plugins.addAll(EmiAgnos.getPlugins().stream().sorted(Comparator.comparingInt(ReloadWorker::entrypointPriority)).toList());
                    for (EmiPluginContainer container : plugins) {
                        EmiReloadManager.step(EmiPort.literal("Loading plugin from " + container.id()), 10000L);
                        long start = System.currentTimeMillis();
                        try {
                            container.plugin().register(registry);
                        }
                        catch (Throwable e) {
                            EmiReloadLog.warn("Exception loading plugin provided by " + container.id(), e);
                            if (!restart) continue;
                            continue block6;
                        }
                        EmiLog.info("Reloaded plugin from " + container.id() + " in " + (System.currentTimeMillis() - start) + "ms");
                        if (!restart) continue;
                        continue block6;
                    }
                    if (restart) continue;
                    EmiData.defaultCategoryOrder();
                    EmiReloadManager.step(EmiPort.literal("Baking index"));
                    EmiStackList.bake();
                    EmiReloadManager.step(EmiPort.literal("Registering late recipes"), 10000L);
                    Consumer<EmiRecipe> registerLateRecipe = registry::addRecipe;
                    for (Consumer<Consumer<EmiRecipe>> consumer : EmiRecipes.lateRecipes) {
                        try {
                            consumer.accept(registerLateRecipe);
                        }
                        catch (Exception e) {
                            EmiReloadLog.warn("Exception loading late recipes for plugins:", e);
                            if (!restart) continue;
                            continue block6;
                        }
                    }
                    EmiReloadManager.step(EmiPort.literal("Baking recipes"), 15000L);
                    EmiRecipes.bake();
                    EmiReloadManager.step(EmiPort.literal("Finishing up"));
                    BoM.reload();
                    EmiPersistentData.load();
                    if (!MinecraftServerHelper.isServer()) {
                        EmiSearch.bake();
                        EmiScreenManager.search.update();
                        EmiScreenManager.forceRecalculate();
                    }
                    EmiReloadLog.bake();
                    EmiLog.info("Reloaded EMI in " + (System.currentTimeMillis() - reloadStart) + "ms");
                    status = 2;
                }
                catch (Throwable e) {
                    EmiReloadLog.warn("Critical error occured during reload:", e);
                    status = -1;
                    if (retries-- <= 0) continue;
                    restart = true;
                }
            } while (restart);
            thread = null;
        }

        private static int entrypointPriority(EmiPluginContainer container) {
            return container.id().equals("emi") ? 0 : 1;
        }
    }
}

