/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.runtime.EmiFavorites;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiSidebars;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import shims.java.net.minecraft.util.JsonHelper;

public class EmiPersistentData {
    public static final File FILE = new File("emi.json");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void save() {
        try {
            JsonObject json = new JsonObject();
            json.add("favorites", (JsonElement)EmiFavorites.save());
            EmiSidebars.save(json);
            json.add("recipe_defaults", (JsonElement)BoM.saveAdded());
            json.add("hidden_stacks", (JsonElement)EmiHidden.save());
            FileWriter writer = new FileWriter(FILE);
            GSON.toJson((JsonElement)json, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            EmiLog.error("Failed to write persistent data", e);
        }
    }

    public static void load() {
        if (!FILE.exists()) {
            return;
        }
        try {
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new FileReader(FILE), JsonObject.class);
            if (JsonHelper.hasArray(json, "favorites")) {
                EmiFavorites.load(JsonHelper.getArray(json, "favorites"));
            }
            EmiSidebars.load(json);
            if (JsonHelper.hasJsonObject(json, "recipe_defaults")) {
                BoM.loadAdded(JsonHelper.getObject(json, "recipe_defaults"));
            }
            if (JsonHelper.hasArray(json, "hidden_stacks")) {
                EmiHidden.load(JsonHelper.getArray(json, "hidden_stacks"));
            }
        }
        catch (Exception e) {
            EmiLog.error("Failed to parse persistent data", e);
        }
    }
}

