/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiPersistentData;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class EmiHidden {
    public static Set<EmiIngredient> pluginDisabledStacks = Sets.newHashSet();
    public static List<Predicate<EmiStack>> pluginDisabledFilters = Lists.newArrayList();
    public static Set<EmiIngredient> hiddenStacks = new LinkedHashSet<EmiIngredient>();

    public static void clear() {
        pluginDisabledStacks.clear();
        pluginDisabledFilters.clear();
    }

    public static JsonArray save() {
        JsonArray arr = new JsonArray();
        for (EmiIngredient stack : hiddenStacks) {
            JsonElement el = EmiIngredientSerializer.getSerialized(stack);
            if (el == null || el.isJsonNull()) continue;
            arr.add(el);
        }
        return arr;
    }

    public static void load(JsonArray arr) {
        hiddenStacks.clear();
        for (JsonElement el : arr) {
            EmiIngredient stack = EmiIngredientSerializer.getDeserialized(el).copy();
            if (stack.isEmpty()) continue;
            for (EmiStack es : stack.getEmiStacks()) {
                es.comparison(c -> Comparison.compareNbt());
            }
            hiddenStacks.add(stack);
        }
        EmiStackList.bakeFiltered();
    }

    public static boolean isHidden(EmiIngredient stack) {
        return hiddenStacks.contains(stack);
    }

    public static void setVisibility(EmiIngredient stack, boolean hide, boolean similar) {
        if (similar && stack.getEmiStacks().size() == 1) {
            EmiStack es = stack.getEmiStacks().get(0);
            for (EmiStack i : EmiStackList.stacks) {
                if (!es.getId().equals((Object)i.getId())) continue;
                if (hide) {
                    hiddenStacks.add(i.copy().comparison(c -> Comparison.compareNbt()));
                    continue;
                }
                hiddenStacks.remove(i);
            }
        } else if (hide) {
            stack = stack.copy();
            for (EmiStack es : stack.getEmiStacks()) {
                es.comparison(c -> Comparison.compareNbt());
            }
            hiddenStacks.add(stack);
        } else {
            hiddenStacks.remove(stack);
        }
        EmiPersistentData.save();
        EmiStackList.bakeFiltered();
    }
}

