/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import dev.emi.emi.api.stack.EmiIngredient;
import net.minecraft.Gui;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import net.minecraft.Tessellator;
import org.lwjgl.opengl.GL11;
import shims.java.com.mojang.blaze3d.systems.RenderSystem;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.util.math.MatrixStack;
import shims.java.net.minecraft.text.OrderedText;
import shims.java.net.minecraft.text.Text;

public class EmiDrawContext {
    private final Minecraft client = Minecraft.getMinecraft();
    private static final EmiDrawContext INSTANCE = new EmiDrawContext();
    public final Gui context = new Gui();

    private EmiDrawContext() {
    }

    public static EmiDrawContext instance() {
        return INSTANCE;
    }

    public static EmiDrawContext wrap(DrawContext ctx) {
        return INSTANCE;
    }

    public DrawContext raw() {
        return DrawContext.INSTANCE;
    }

    public MatrixStack matrices() {
        return MatrixStack.INSTANCE;
    }

    public void push() {
        GL11.glPushMatrix();
    }

    public void pop() {
        GL11.glPopMatrix();
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int u, int v, int w, int h) {
        GL11.glDisable((int)2896);
        this.drawTexture(texture, x, y, w, h, u, v, w, h, 256, 256);
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int z, float u, float v, int w, int h) {
        GL11.glDisable((int)2896);
        this.drawTexture(texture, x, y, z, u, v, w, h, 256, 256);
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int z, float u, float v, int w, int h, int textureWidth, int textureHeight) {
        GL11.glDisable((int)2896);
        this.drawTexture(texture, x, y, z, w, h, u, v, w, h, textureWidth, textureHeight);
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int w, int h, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        GL11.glDisable((int)2896);
        this.drawTexture(texture, x, y, 0, w, h, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int z, int w, int h, float u, float v, int rW, int rH, int textureWidth, int textureHeight) {
        this.client.getTextureManager().bindTexture(texture);
        float uM = 1.0f / (float)textureWidth;
        float vM = 1.0f / (float)textureHeight;
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)(x + 0), (double)(y + h), (double)z, (double)((u + 0.0f) * uM), (double)((v + (float)rH) * vM));
        tess.addVertexWithUV((double)(x + w), (double)(y + h), (double)z, (double)((u + (float)rW) * uM), (double)((v + (float)rH) * vM));
        tess.addVertexWithUV((double)(x + w), (double)(y + 0), (double)z, (double)((u + (float)rW) * uM), (double)((v + 0.0f) * vM));
        tess.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)z, (double)((u + 0.0f) * uM), (double)((v + 0.0f) * vM));
        tess.draw();
    }

    public void fill(int x, int y, int width, int height, int color) {
        this.fillInner(x, y, x + width, y + height, color);
    }

    public void fillInner(int x, int y, int w, int h, int color) {
        int temp;
        if (x < w) {
            temp = x;
            x = w;
            w = temp;
        }
        if (y < h) {
            temp = y;
            y = h;
            h = temp;
        }
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        GL11.glDisable((int)3553);
        RenderSystem.defaultBlendFunc();
        this.setColor(red, green, blue, alpha);
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.addVertex((double)x, (double)h, 0.0);
        tess.addVertex((double)w, (double)h, 0.0);
        tess.addVertex((double)w, (double)y, 0.0);
        tess.addVertex((double)x, (double)y, 0.0);
        tess.draw();
        RenderSystem.disableBlend();
        GL11.glEnable((int)3553);
    }

    public void drawText(Text text, int x, int y) {
        this.drawText(text, x, y, -1);
    }

    public void drawText(Text text, int x, int y, int color) {
        this.client.fontRenderer.drawString(text.asString(), x, y, color);
    }

    public void drawText(OrderedText text, int x, int y, int color) {
        this.client.fontRenderer.drawString(text.asString(), x, y, color);
    }

    public void drawTextWithShadow(Text text, int x, int y) {
        this.drawTextWithShadow(text, x, y, -1);
    }

    public void drawTextWithShadow(Text text, int x, int y, int color) {
        this.client.fontRenderer.drawStringWithShadow(text.asString(), x, y, color);
    }

    public void drawTextWithShadow(OrderedText text, int x, int y, int color) {
        this.client.fontRenderer.drawStringWithShadow(text.asString(), x, y, color);
    }

    public void drawCenteredText(Text text, int x, int y) {
        this.drawCenteredText(text, x, y, -1);
    }

    public void drawCenteredText(Text text, int x, int y, int color) {
        this.client.fontRenderer.drawString(text.asString(), x - this.client.fontRenderer.getStringWidth(text.asString()) / 2, y, color);
    }

    public void drawCenteredTextWithShadow(Text text, int x, int y) {
        this.drawCenteredTextWithShadow(text, x, y, -1);
    }

    public void drawCenteredTextWithShadow(Text text, int x, int y, int color) {
        this.client.fontRenderer.drawStringWithShadow(text.asString(), x - this.client.fontRenderer.getStringWidth(text.asString()) / 2, y, color);
    }

    public void resetColor() {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setColor(float r, float g, float b) {
        this.setColor(r, g, b, 1.0f);
    }

    public void setColor(float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public void drawStack(EmiIngredient stack, int x, int y) {
        stack.render(this.raw(), x, y, this.client.timer.renderPartialTicks);
    }

    public void drawStack(EmiIngredient stack, int x, int y, int flags) {
        this.drawStack(stack, x, y, this.client.timer.renderPartialTicks, flags);
    }

    public void drawStack(EmiIngredient stack, int x, int y, float delta, int flags) {
        stack.render(this.raw(), x, y, delta, flags);
    }
}

