/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.Prototype;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.TagExclusions;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.Item;
import net.minecraft.ResourceLocation;
import net.minecraft.StringTranslate;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.tag.TagKey;
import shims.java.net.minecraft.tag.WildcardItemTag;
import shims.java.net.minecraft.text.Text;

public class EmiTags {
    public static final ResourceLocation HIDDEN_FROM_RECIPE_VIEWERS = new ResourceLocation("c", "hidden_from_recipe_viewers");
    private static final Map<TagKey<?>, ResourceLocation> MODELED_TAGS = Maps.newHashMap();
    private static final Map<Set<?>, List<TagKey<?>>> CACHED_TAGS = Maps.newHashMap();
    private static final Map<TagKey<?>, List<?>> TAG_VALUES = Maps.newHashMap();
    private static final List<TagKey<Prototype>> SORTED_ITEM_TAGS = Lists.newArrayList();
    public static final List<TagKey<?>> TAGS = Lists.newArrayList();
    public static TagExclusions exclusions = new TagExclusions();

    public static <T> List<EmiStack> getValues(TagKey<T> key) {
        List<Object> values = TAG_VALUES.get(key);
        if (values == null) {
            values = key.get();
        }
        if (key instanceof WildcardItemTag) {
            return values.stream().map(t -> EmiStack.of((Prototype)t)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static <T> EmiIngredient getIngredient(Class<T> clazz, List<EmiStack> stacks, long amount) {
        HashMap map = Maps.newHashMap();
        for (EmiStack emiStack : stacks) {
            if (emiStack.isEmpty()) continue;
            map.put(emiStack.getKey(), emiStack);
        }
        if (map.size() == 0) {
            return EmiStack.EMPTY;
        }
        if (map.size() == 1) {
            return ((EmiStack)map.values().stream().collect(Collectors.toList()).get(0)).copy().setAmount(amount);
        }
        ArrayList keys = CACHED_TAGS.get(map.keySet());
        if (keys != null) {
            for (TagKey<?> key : keys) {
                List<?> values = TAG_VALUES.get(key);
                map.keySet().removeAll(values);
            }
        } else {
            keys = Lists.newArrayList();
            HashSet hashSet = new HashSet(map.keySet());
            for (TagKey<T> key : EmiTags.getTags(clazz)) {
                List<?> values = TAG_VALUES.get(key);
                if (values.size() < 2) continue;
                if (map.keySet().containsAll(values)) {
                    map.keySet().removeAll(values);
                    keys.add(key);
                }
                if (!map.isEmpty()) continue;
                break;
            }
            CACHED_TAGS.put(hashSet, keys);
        }
        if (keys == null || keys.isEmpty()) {
            return new ListEmiIngredient(stacks.stream().collect(Collectors.toList()), amount);
        }
        if (map.isEmpty()) {
            if (keys.size() == 1) {
                return new TagEmiIngredient((TagKey)keys.get(0), amount);
            }
            return new ListEmiIngredient(keys.stream().map(k -> new TagEmiIngredient((TagKey<?>)k, 1L)).collect(Collectors.toList()), amount);
        }
        return new ListEmiIngredient(List.of(map.values().stream().map(i -> i.copy().setAmount(1L)).collect(Collectors.toList()), keys.stream().map(k -> new TagEmiIngredient((TagKey<?>)k, 1L)).collect(Collectors.toList())).stream().flatMap(a -> a.stream()).collect(Collectors.toList()), amount);
    }

    public static <T> List<TagKey<T>> getTags(Class<T> clazz) {
        return clazz == Prototype.class ? SORTED_ITEM_TAGS : Collections.emptyList();
    }

    public static Text getTagName(TagKey<?> key) {
        String s = EmiTags.getTagTranslationKey(key);
        if (s == null) {
            return EmiPort.literal("#" + key.id());
        }
        return EmiPort.translatable(s);
    }

    public static boolean hasTranslation(TagKey<?> key) {
        return EmiTags.getTagTranslationKey(key) != null;
    }

    @Nullable
    private static String getTagTranslationKey(TagKey<?> key) {
        return EmiTags.translatePrefix(key.id());
    }

    @Nullable
    private static String translatePrefix(ResourceLocation id) {
        String s = EmiUtil.translateId("tag.", id);
        if (StringTranslate.getInstance().containsTranslateKey(s)) {
            return s;
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getCustomModel(TagKey<?> key) {
        return MODELED_TAGS.get(key);
    }

    public static boolean hasCustomModel(TagKey<?> key) {
        return EmiTags.getCustomModel(key) != null;
    }

    public static void reload() {
        TAGS.clear();
        SORTED_ITEM_TAGS.clear();
        TAG_VALUES.clear();
        CACHED_TAGS.clear();
        EmiTags.reloadTags();
    }

    private static void reloadTags() {
        List itemTags = new ArrayList();
        ArrayList li = new ArrayList();
        for (Item i : Item.itemsList) {
            if (i == null) continue;
            li.clear();
            i.getSubItems(i.itemID, i.getCreativeTab(), li);
            if (li.size() <= 1) continue;
            itemTags.add(new WildcardItemTag(i));
        }
        EmiTags.logUntranslatedTags(itemTags);
        itemTags = EmiTags.consolodateTags(itemTags);
        for (TagKey tagKey : itemTags) {
            TAG_VALUES.put(tagKey, tagKey.get());
        }
        List tags = itemTags.stream().toList();
        TAGS.addAll(tags.stream().sorted(Comparator.comparing(Object::toString)).toList());
        itemTags = itemTags.stream().sorted((a, b) -> Long.compare(b.get().size(), b.get().size())).collect(Collectors.toList());
        SORTED_ITEM_TAGS.addAll(itemTags);
    }

    private static void logUntranslatedTags(List<? extends TagKey<?>> tags) {
        if (EmiConfig.logUntranslatedTags) {
            ArrayList untranslated = Lists.newArrayList();
            for (TagKey<?> tag : tags) {
                if (EmiTags.hasTranslation(tag)) continue;
                EmiLog.warn("WARNING Untranslated tag: " + EmiUtil.translateId("tag.", tag.id()));
                untranslated.add(tag.id().toString());
            }
            if (!untranslated.isEmpty()) {
                for (TagKey<?> tag : untranslated.stream().sorted().collect(Collectors.toList())) {
                    EmiReloadLog.warn("Untranslated tag " + (String)((Object)tag));
                }
                EmiReloadLog.info(" Tag warning can be disabled in the config, EMI docs describe how to add a translation or exclude tags.");
            }
        }
    }

    private static <T> List<TagKey<T>> consolodateTags(List<TagKey<T>> tags) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tags.size(); ++i) {
            TagKey<T> key = tags.get(i);
            HashSet<T> values = new HashSet<T>(key.get());
            TagKey original = (TagKey)map.get(values);
            if (original != null) {
                map.put(values, EmiTags.betterTag(key, original));
                continue;
            }
            map.put(values, key);
        }
        return map.values().stream().collect(Collectors.toList());
    }

    private static <T> TagKey<T> betterTag(TagKey<T> a, TagKey<T> b) {
        String bn;
        if (EmiTags.hasTranslation(a) != EmiTags.hasTranslation(b)) {
            return EmiTags.hasTranslation(a) ? a : b;
        }
        if (EmiTags.hasCustomModel(a) != EmiTags.hasCustomModel(b)) {
            return EmiTags.hasCustomModel(a) ? a : b;
        }
        String an = a.id().getResourceDomain();
        if (!an.equals(bn = b.id().getResourceDomain())) {
            if (an.equals("wildcard")) {
                return a;
            }
            if (bn.equals("wildcard")) {
                return b;
            }
            if (an.equals("minecraft")) {
                return a;
            }
            if (bn.equals("minecraft")) {
                return b;
            }
            if (an.equals("c")) {
                return a;
            }
            if (bn.equals("c")) {
                return b;
            }
            if (an.equals("fabric")) {
                return EmiAgnos.isModLoaded("fabric") ? b : a;
            }
            if (bn.equals("fabric")) {
                return EmiAgnos.isModLoaded("fabric") ? a : b;
            }
        }
        return a.id().toString().length() <= b.id().toString().length() ? a : b;
    }
}

