/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.registry.EmiStackProvidersClientOnly;
import java.util.List;
import java.util.Map;
import moddedmite.emi.api.EMIGuiContainerCreative;
import net.minecraft.GuiContainer;
import net.minecraft.GuiScreen;
import net.minecraft.ItemStack;
import net.minecraft.Slot;
import shims.java.com.unascribed.retroemi.ItemStacks;

public class EmiStackProviders {
    public static Map<Class<?>, List<EmiStackProvider<?>>> fromClass = Maps.newHashMap();
    public static List<EmiStackProvider<?>> generic = Lists.newArrayList();

    public static void clear() {
        fromClass.clear();
        generic.clear();
    }

    public static EmiStackInteraction getStackAt(GuiScreen screen, int x, int y, boolean notClick) {
        GuiContainer handled;
        Slot s;
        EmiStackInteraction stack;
        if (fromClass.containsKey(screen.getClass())) {
            for (EmiStackProvider<?> provider : fromClass.get(screen.getClass())) {
                stack = provider.getStackAt(screen, x, y);
                if (stack.isEmpty() || !notClick && !stack.isClickable()) continue;
                return stack;
            }
        }
        for (EmiStackProvider<?> handler : generic) {
            stack = handler.getStackAt(screen, x, y);
            if (stack.isEmpty() || !notClick && !stack.isClickable()) continue;
            return stack;
        }
        if (notClick && screen instanceof GuiContainer && (s = ((EMIGuiContainerCreative)(handled = (GuiContainer)screen)).getTheSlot()) != null && !ItemStacks.isEmpty((ItemStack)(stack = s.getStack()))) {
            EmiStackInteraction stack1 = EmiStackProvidersClientOnly.getEmiStackInteraction(s, (ItemStack)stack);
            if (stack1 != null) {
                return stack1;
            }
            return new EmiStackInteraction(EmiStack.of((ItemStack)stack));
        }
        return EmiStackInteraction.EMPTY;
    }
}

