/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocation;
import net.minecraft.StringTranslate;
import org.jetbrains.annotations.Nullable;

public class EmiRecipes {
    public static volatile Worker activeWorker = null;
    public static EmiRecipeManager manager = Manager.EMPTY;
    public static List<Consumer<Consumer<EmiRecipe>>> lateRecipes = Lists.newArrayList();
    public static List<Predicate<EmiRecipe>> invalidators = Lists.newArrayList();
    public static List<EmiRecipeCategory> categories = Lists.newArrayList();
    private static Map<EmiRecipeCategory, List<EmiIngredient>> workstations = Maps.newHashMap();
    private static List<EmiRecipe> recipes = Lists.newArrayList();
    public static Map<EmiStack, List<EmiRecipe>> byWorkstation = Maps.newHashMap();

    public static void clear() {
        EmiRecipes.setWorker(null);
        lateRecipes.clear();
        invalidators.clear();
        categories.clear();
        workstations.clear();
        recipes.clear();
        byWorkstation.clear();
        manager = Manager.EMPTY;
    }

    public static void bake() {
        long start = System.currentTimeMillis();
        categories.sort(Comparator.comparingInt(EmiRecipeCategoryProperties::getOrder));
        invalidators.addAll(EmiData.recipeFilters);
        List<EmiRecipe> filtered = recipes.stream().filter(r -> {
            for (Predicate<EmiRecipe> predicate : invalidators) {
                if (!predicate.test((EmiRecipe)r)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        manager = new Manager(categories, workstations, filtered, false);
        EmiRecipes.setWorker(new Worker(categories, workstations, filtered));
        EmiLog.info("Baked " + recipes.size() + " recipes in " + (System.currentTimeMillis() - start) + "ms");
    }

    public static void addCategory(EmiRecipeCategory category) {
        categories.add(category);
    }

    public static void addWorkstation(EmiRecipeCategory category, EmiIngredient workstation) {
        workstations.computeIfAbsent(category, k -> Lists.newArrayList()).add(workstation);
    }

    public static void addRecipe(EmiRecipe recipe) {
        recipes.add(recipe);
    }

    private static synchronized void setWorker(Worker worker) {
        activeWorker = worker;
        if (worker != null) {
            new Thread(activeWorker).start();
        }
    }

    private static class Worker
    implements Runnable {
        private List<EmiRecipeCategory> categories;
        private Map<EmiRecipeCategory, List<EmiIngredient>> workstations;
        private List<EmiRecipe> recipes;

        public Worker(List<EmiRecipeCategory> categories, Map<EmiRecipeCategory, List<EmiIngredient>> workstations, List<EmiRecipe> recipes) {
            this.categories = categories;
            this.workstations = workstations;
            this.recipes = recipes;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            Manager manager = new Manager(this.categories, this.workstations, this.recipes, true);
            if (activeWorker == this) {
                long endTime = System.currentTimeMillis();
                EmiLog.info("Baked recipes after reload in " + (endTime - startTime) + "ms");
                EmiRecipes.manager = manager;
            }
            EmiRecipes.setWorker(null);
        }
    }

    private static class Manager
    implements EmiRecipeManager {
        public static final EmiRecipeManager EMPTY = new Manager();
        private final List<EmiRecipeCategory> categories;
        private final Map<EmiRecipeCategory, List<EmiIngredient>> workstations;
        private final List<EmiRecipe> recipes;
        private Map<EmiStack, List<EmiRecipe>> byInput = Maps.newHashMap();
        private Map<EmiStack, List<EmiRecipe>> byOutput = Maps.newHashMap();
        private Map<EmiRecipeCategory, List<EmiRecipe>> byCategory = Maps.newHashMap();
        private Map<ResourceLocation, EmiRecipe> byId = Maps.newHashMap();

        private Manager() {
            this.categories = Collections.emptyList();
            this.workstations = Collections.emptyMap();
            this.recipes = Collections.emptyList();
        }

        public Manager(List<EmiRecipeCategory> categories, Map<EmiRecipeCategory, List<EmiIngredient>> workstations, List<EmiRecipe> recipes, boolean doSort) {
            this.categories = categories.stream().distinct().collect(Collectors.toList());
            this.workstations = workstations;
            this.recipes = Lists.newArrayList(recipes);
            HashMap byInput = Maps.newHashMap();
            HashMap byOutput = Maps.newHashMap();
            Object2IntOpenHashMap duplicateIds = new Object2IntOpenHashMap();
            for (EmiRecipe emiRecipe : recipes) {
                ResourceLocation id = emiRecipe.getId();
                EmiRecipeCategory category = emiRecipe.getCategory();
                if (!categories.contains(category)) {
                    EmiReloadLog.warn("Recipe " + id + " loaded with unregistered category: " + category.getId());
                }
                if (EmiConfig.logNonTagIngredients && emiRecipe.supportsRecipeTree()) {
                    ObjectArraySet seen = new ObjectArraySet(0);
                    for (EmiIngredient ingredient : emiRecipe.getInputs()) {
                        if (!(ingredient instanceof ListEmiIngredient) || seen.contains(ingredient)) continue;
                        EmiReloadLog.warn("Recipe " + emiRecipe.getId() + " uses non-tag ingredient: " + ingredient);
                        seen.add(ingredient);
                    }
                }
                this.byCategory.computeIfAbsent(category, a -> Lists.newArrayList()).add(emiRecipe);
                if (id == null) continue;
                if (this.byId.containsKey(id)) {
                    duplicateIds.put((Object)id, duplicateIds.getOrDefault((Object)id, 1) + 1);
                    continue;
                }
                this.byId.put(id, emiRecipe);
            }
            if (EmiConfig.devMode) {
                for (ResourceLocation resourceLocation : duplicateIds.keySet()) {
                    EmiReloadLog.warn(duplicateIds.getInt((Object)resourceLocation) + " recipes loaded with the same id: " + resourceLocation);
                }
            }
            for (EmiRecipeCategory emiRecipeCategory : this.byCategory.keySet()) {
                String key = EmiUtil.translateId("emi.category.", emiRecipeCategory.getId());
                if (emiRecipeCategory.getName().equals(EmiPort.translatable(key)) && !StringTranslate.getInstance().containsTranslateKey(key)) {
                    EmiReloadLog.warn("Untranslated recipe category " + emiRecipeCategory.getId());
                }
                List<EmiRecipe> cRecipes = this.byCategory.get(emiRecipeCategory);
                Comparator<EmiRecipe> sort = EmiRecipeCategoryProperties.getSort(emiRecipeCategory);
                if (doSort && sort != EmiRecipeSorting.none()) {
                    cRecipes = cRecipes.stream().sorted(sort).collect(Collectors.toList());
                }
                this.byCategory.put(emiRecipeCategory, cRecipes);
                for (EmiRecipe recipe : cRecipes) {
                    recipe.getInputs().stream().flatMap(i -> i.getEmiStacks().stream()).forEach(i -> byInput.computeIfAbsent(i, b -> Sets.newLinkedHashSet()).add(recipe));
                    recipe.getCatalysts().stream().flatMap(i -> i.getEmiStacks().stream()).forEach(i -> byInput.computeIfAbsent(i, b -> Sets.newLinkedHashSet()).add(recipe));
                    recipe.getOutputs().forEach(i -> byOutput.computeIfAbsent(i, b -> Sets.newLinkedHashSet()).add(recipe));
                }
            }
            this.byInput = byInput.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, m -> new ArrayList((Collection)m.getValue())));
            this.byOutput = byOutput.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, m -> new ArrayList((Collection)m.getValue())));
            workstations.replaceAll((c, v) -> ((List)workstations.get(c)).stream().distinct().collect(Collectors.toList()));
            for (Map.Entry entry : this.byCategory.entrySet()) {
                for (EmiIngredient ingredient : workstations.getOrDefault(entry.getKey(), Collections.emptyList())) {
                    for (EmiStack stack : ingredient.getEmiStacks()) {
                        byWorkstation.computeIfAbsent(stack, s -> Lists.newArrayList()).addAll((Collection)entry.getValue());
                    }
                }
            }
        }

        @Override
        public List<EmiRecipeCategory> getCategories() {
            return this.categories;
        }

        @Override
        public List<EmiIngredient> getWorkstations(EmiRecipeCategory category) {
            return this.workstations.getOrDefault(category, Collections.emptyList());
        }

        @Override
        public List<EmiRecipe> getRecipes() {
            return this.recipes;
        }

        @Override
        public List<EmiRecipe> getRecipes(EmiRecipeCategory category) {
            return this.byCategory.getOrDefault(category, Collections.emptyList());
        }

        @Override
        @Nullable
        public EmiRecipe getRecipe(ResourceLocation id) {
            return this.byId.getOrDefault(id, null);
        }

        @Override
        public List<EmiRecipe> getRecipesByInput(EmiStack stack) {
            return this.byInput.getOrDefault(stack, Collections.emptyList());
        }

        @Override
        public List<EmiRecipe> getRecipesByOutput(EmiStack stack) {
            return this.byOutput.getOrDefault(stack, Collections.emptyList());
        }
    }
}

