/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiFillAction;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.handler.CoercedRecipeHandler;
import dev.emi.emi.runtime.EmiSidebars;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import moddedmite.emi.api.EMISlotCrafting;
import net.minecraft.Container;
import net.minecraft.ContainerPlayer;
import net.minecraft.EntityClientPlayerMP;
import net.minecraft.EntityPlayer;
import net.minecraft.GuiContainer;
import net.minecraft.GuiInventory;
import net.minecraft.IInventory;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import net.minecraft.PlayerControllerMP;
import net.minecraft.Slot;
import net.minecraft.SlotCrafting;
import org.jetbrains.annotations.Nullable;
import shims.java.com.unascribed.retroemi.ItemStacks;
import shims.java.com.unascribed.retroemi.RetroEMI;

public class EmiRecipeFiller {
    public static Map<Class<? extends Container>, List<EmiRecipeHandler<?>>> handlers = Maps.newHashMap();
    public static BiFunction<Container, EmiRecipe, EmiRecipeHandler<?>> extraHandlers = (h, r) -> null;

    public static void clear() {
        handlers.clear();
        extraHandlers = (h, r) -> null;
    }

    public static boolean isSupported(EmiRecipe recipe) {
        for (List<EmiRecipeHandler<?>> list : handlers.values()) {
            for (EmiRecipeHandler<?> handler : list) {
                if (!handler.supportsRecipe(recipe) || !handler.alwaysDisplaySupport(recipe)) continue;
                return true;
            }
        }
        GuiContainer hs = EmiApi.getHandledScreen();
        if (hs != null) {
            for (EmiRecipeHandler emiRecipeHandler : EmiRecipeFiller.getAllHandlers(hs)) {
                if (!emiRecipeHandler.supportsRecipe(recipe)) continue;
                return true;
            }
            EmiRecipeHandler<?> emiRecipeHandler = extraHandlers.apply(hs.inventorySlots, recipe);
            if (emiRecipeHandler != null && emiRecipeHandler.supportsRecipe(recipe)) {
                return true;
            }
        }
        return false;
    }

    public static <T extends Container> List<EmiRecipeHandler<T>> getAllHandlers(GuiContainer screen) {
        if (screen != null) {
            Class<?> type;
            Container screenHandler = screen.inventorySlots;
            try {
                type = screenHandler instanceof ContainerPlayer ? null : screenHandler.getClass();
            }
            catch (UnsupportedOperationException e) {
                type = null;
            }
            if ((type != null || screenHandler instanceof ContainerPlayer) && handlers.containsKey(type)) {
                return handlers.get(type);
            }
            for (Slot slot : screen.inventorySlots.inventorySlots) {
                SlotCrafting crs;
                IInventory inv;
                if (!(slot instanceof SlotCrafting) || (inv = ((EMISlotCrafting)(crs = (SlotCrafting)slot)).getCraftMatrix()) == null || inv.getSizeInventory() <= 0) continue;
                return List.of(new CoercedRecipeHandler(crs));
            }
        }
        return List.of();
    }

    @Nullable
    public static <T extends Container> EmiRecipeHandler<T> getFirstValidHandler(EmiRecipe recipe, GuiContainer screen) {
        EmiRecipeHandler<?> extra;
        EmiRecipeHandler<Object> ret = null;
        for (EmiRecipeHandler<T> handler : EmiRecipeFiller.getAllHandlers(screen)) {
            if (!handler.supportsRecipe(recipe)) continue;
            ret = handler;
            break;
        }
        if ((ret == null || ret instanceof CoercedRecipeHandler && !(screen instanceof GuiInventory)) && (extra = extraHandlers.apply(screen.inventorySlots, recipe)) != null) {
            ret = extra;
        }
        return ret;
    }

    public static <T extends Container> boolean performFill(EmiRecipe recipe, GuiContainer screen, EmiFillAction action, int amount) {
        EmiRecipeHandler handler = EmiRecipeFiller.getFirstValidHandler(recipe, screen);
        if (handler != null && handler.supportsRecipe(recipe)) {
            EmiPlayerInventory inv = handler.getInventory(screen);
            EmiCraftContext context = new EmiCraftContext(screen, inv, EmiCraftContext.Type.FILL_BUTTON, switch (action) {
                default -> throw new IncompatibleClassChangeError();
                case EmiFillAction.FILL -> EmiCraftContext.Destination.NONE;
                case EmiFillAction.QUICK_MOVE -> EmiCraftContext.Destination.INVENTORY;
                case EmiFillAction.CURSOR -> EmiCraftContext.Destination.CURSOR;
            }, amount);
            if (handler.canCraft(recipe, context)) {
                EmiSidebars.craft(recipe);
                return handler.craft(recipe, context);
            }
        }
        return false;
    }

    @Nullable
    public static <T extends Container> List<ItemStack> getStacks(StandardRecipeHandler<T> handler, EmiRecipe recipe, GuiContainer screen, int amount) {
        try {
            Container screenHandler = screen.inventorySlots;
            if (handler != null) {
                List<Slot> slots = handler.getInputSources(screenHandler);
                List<Slot> craftingSlots = handler.getCraftingSlots(recipe, screenHandler);
                List<EmiIngredient> ingredients = recipe.getInputs();
                ArrayList discovered = Lists.newArrayList();
                Object2IntOpenHashMap weightDivider = new Object2IntOpenHashMap();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Object stack;
                    ArrayList d = Lists.newArrayList();
                    EmiIngredient ingredient = ingredients.get(i);
                    List<EmiStack> emiStacks = ingredient.getEmiStacks();
                    if (ingredient.isEmpty()) {
                        discovered.add(null);
                        continue;
                    }
                    for (int e = 0; e < emiStacks.size(); ++e) {
                        stack = emiStacks.get(e);
                        block4: for (Slot s : slots) {
                            ItemStack ss = s.getStack();
                            if (!EmiStack.of(s.getStack()).isEqual((EmiStack)stack)) continue;
                            Iterator iterator = d.iterator();
                            while (iterator.hasNext()) {
                                DiscoveredItem di = (DiscoveredItem)iterator.next();
                                if (!RetroEMI.canCombine(ss, di.stack)) continue;
                                di.amount += ss.stackSize;
                                continue block4;
                            }
                            d.add(new DiscoveredItem((EmiStack)stack, ss, ss.stackSize, (int)ingredient.getAmount(), ss.getMaxStackSize()));
                        }
                    }
                    DiscoveredItem biggest = null;
                    stack = d.iterator();
                    while (stack.hasNext()) {
                        DiscoveredItem di = (DiscoveredItem)stack.next();
                        if (biggest == null) {
                            biggest = di;
                            continue;
                        }
                        int a = di.amount / (weightDivider.getOrDefault((Object)di.ingredient, 0) + di.consumed);
                        int ba = biggest.amount / (weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                        if (ba >= a) continue;
                        biggest = di;
                    }
                    if (biggest == null || i >= craftingSlots.size()) {
                        return null;
                    }
                    Slot slot = craftingSlots.get(i);
                    if (recipe instanceof EmiCraftingRecipe) {
                        EmiCraftingRecipe craft = (EmiCraftingRecipe)recipe;
                        if (craft.shapeless && i > 1 && screen instanceof GuiInventory) {
                            slot = craftingSlots.get(i + 1);
                        }
                    }
                    if (slot == null) {
                        return null;
                    }
                    weightDivider.put((Object)biggest.ingredient, weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                    biggest.max = Math.min(biggest.max, 64);
                    discovered.add(biggest);
                }
                if (discovered.isEmpty()) {
                    return null;
                }
                ArrayList unique = Lists.newArrayList();
                block7: for (Object di : discovered) {
                    if (di == null) continue;
                    for (DiscoveredItem ui : unique) {
                        if (!RetroEMI.canCombine(((DiscoveredItem)di).stack, ui.stack)) continue;
                        ui.consumed += ((DiscoveredItem)di).consumed;
                        continue block7;
                    }
                    unique.add(new DiscoveredItem(((DiscoveredItem)di).ingredient, ((DiscoveredItem)di).stack, ((DiscoveredItem)di).amount, ((DiscoveredItem)di).consumed, ((DiscoveredItem)di).max));
                }
                int maxAmount = Integer.MAX_VALUE;
                for (DiscoveredItem ui : unique) {
                    if (ui.catalyst()) continue;
                    maxAmount = Math.min(maxAmount, ui.amount / ui.consumed);
                    maxAmount = Math.min(maxAmount, ui.max);
                }
                if ((maxAmount = Math.min(maxAmount, amount + EmiRecipeFiller.batchesAlreadyPresent(recipe, handler, screen))) == 0) {
                    return null;
                }
                ArrayList desired = Lists.newArrayList();
                for (int i = 0; i < discovered.size(); ++i) {
                    DiscoveredItem di = (DiscoveredItem)discovered.get(i);
                    if (di != null) {
                        int a;
                        ItemStack is = di.stack.copy();
                        is.stackSize = a = di.catalyst() ? di.consumed : di.consumed * maxAmount;
                        desired.add(is);
                        continue;
                    }
                    desired.add(ItemStacks.EMPTY);
                }
                return desired;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T extends Container> int batchesAlreadyPresent(EmiRecipe recipe, StandardRecipeHandler<T> handler, GuiContainer screen) {
        List<EmiIngredient> inputs = recipe.getInputs();
        ArrayList stacks = Lists.newArrayList();
        Slot output = handler.getOutputSlot(screen.inventorySlots);
        if (output != null && !ItemStacks.isEmpty(output.getStack()) && recipe.getOutputs().size() > 0 && !RetroEMI.canCombine(output.getStack(), recipe.getOutputs().get(0).getItemStack())) {
            return 0;
        }
        for (Slot slot : handler.getCraftingSlots(recipe, screen.inventorySlots)) {
            if (slot != null) {
                stacks.add(slot.getStack());
                continue;
            }
            stacks.add(ItemStacks.EMPTY);
        }
        long amount = Long.MAX_VALUE;
        block1: for (int i = 0; i < inputs.size(); ++i) {
            EmiIngredient input = inputs.get(i);
            if (input.isEmpty()) {
                if (ItemStacks.isEmpty((ItemStack)stacks.get(i))) continue;
                return 0;
            }
            if (i >= stacks.size()) {
                return 0;
            }
            EmiStack es = EmiStack.of((ItemStack)stacks.get(i));
            for (EmiStack v : input.getEmiStacks()) {
                if (v.isEmpty() || !v.isEqual(es) || es.getAmount() < v.getAmount()) continue;
                amount = Math.min(amount, es.getAmount() / v.getAmount());
                continue block1;
            }
            return 0;
        }
        if (amount < Long.MAX_VALUE && amount > 0L) {
            return (int)amount;
        }
        return 0;
    }

    public static <T extends Container> boolean clientFill(StandardRecipeHandler<T> handler, EmiRecipe recipe, GuiContainer screen, List<ItemStack> stacks, EmiCraftContext.Destination destination) {
        Minecraft client = Minecraft.getMinecraft();
        Container screenHandler = screen.inventorySlots;
        if (handler != null && client.thePlayer.inventory.getItemStack() == null) {
            PlayerControllerMP manager = client.playerController;
            EntityClientPlayerMP player = client.thePlayer;
            List<Slot> clear = handler.getCraftingSlots(screenHandler);
            for (Slot slot : clear) {
                if (slot == null) continue;
                manager.windowClick(screenHandler.windowId, slot.slotNumber, 0, 1, (EntityPlayer)player);
            }
            List<Slot> inputs = handler.getInputSources(screenHandler);
            List<Slot> slots = handler.getCraftingSlots(recipe, screenHandler);
            block1: for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = stacks.get(i);
                if (ItemStacks.isEmpty(stack)) continue;
                if (i >= slots.size()) {
                    return false;
                }
                Slot crafting = slots.get(i);
                if (recipe instanceof EmiCraftingRecipe) {
                    EmiCraftingRecipe craf = (EmiCraftingRecipe)recipe;
                    if (craf.shapeless && i > 1 && screen instanceof GuiInventory) {
                        crafting = slots.get(i + 1);
                    }
                }
                if (crafting == null) {
                    return false;
                }
                int needed = stack.stackSize;
                for (Slot input : inputs) {
                    if (slots.contains(input) || input.getStack() == null) continue;
                    ItemStack is = input.getStack().copy();
                    if (RetroEMI.canCombine(is, stack)) {
                        manager.windowClick(screenHandler.windowId, input.slotNumber, 0, 0, (EntityPlayer)player);
                        if (is.stackSize <= needed) {
                            needed -= is.stackSize;
                            manager.windowClick(screenHandler.windowId, crafting.slotNumber, 0, 0, (EntityPlayer)player);
                        } else {
                            while (needed > 0) {
                                manager.windowClick(screenHandler.windowId, crafting.slotNumber, 1, 0, (EntityPlayer)player);
                                --needed;
                            }
                            manager.windowClick(screenHandler.windowId, input.slotNumber, 0, 0, (EntityPlayer)player);
                        }
                    }
                    if (needed != 0) continue;
                    continue block1;
                }
                return false;
            }
            Slot slot = handler.getOutputSlot(screenHandler);
            if (slot != null) {
                if (destination == EmiCraftContext.Destination.CURSOR) {
                    manager.windowClick(screenHandler.windowId, slot.slotNumber, 0, 0, (EntityPlayer)player);
                } else if (destination == EmiCraftContext.Destination.INVENTORY) {
                    manager.windowClick(screenHandler.windowId, slot.slotNumber, 0, 1, (EntityPlayer)player);
                }
            }
            return true;
        }
        return false;
    }

    private static class DiscoveredItem {
        private static final Comparison COMPARISON = Comparison.DEFAULT_COMPARISON;
        public EmiStack ingredient;
        public ItemStack stack;
        public int consumed;
        public int amount;
        public int max;

        public DiscoveredItem(EmiStack ingredient, ItemStack stack, int amount, int consumed, int max) {
            this.ingredient = ingredient;
            this.stack = stack.copy();
            this.amount = amount;
            this.consumed = consumed;
            this.max = max;
        }

        public boolean catalyst() {
            return this.ingredient.getRemainder().isEqual(this.ingredient, COMPARISON);
        }
    }
}

