/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import dev.emi.emi.network.CommandS2CPacket;
import dev.emi.emi.network.EmiNetwork;
import java.util.List;
import net.minecraft.CommandBase;
import net.minecraft.ICommandSender;
import net.minecraft.ResourceLocation;
import net.minecraft.ServerPlayer;
import net.minecraft.WrongUsageException;
import org.jetbrains.annotations.Nullable;

public class EmiCommands
extends CommandBase {
    public static final byte VIEW_RECIPE = 1;
    public static final byte VIEW_TREE = 2;
    public static final byte TREE_GOAL = 17;
    public static final byte TREE_RESOLUTION = 18;

    public String getCommandName() {
        return "emi";
    }

    public String getCommandUsage(ICommandSender var1) {
        return "commands.emi.usage";
    }

    public void processCommand(ICommandSender sender, String[] userInputStrings) {
        if (userInputStrings.length > 2) {
            ServerPlayer player = EmiCommands.getPlayer((ICommandSender)sender, (String)userInputStrings[0]);
            if (userInputStrings[0].equals("view")) {
                if (userInputStrings[1].equals("recipe")) {
                    if (userInputStrings[2].isEmpty()) {
                        throw new WrongUsageException("commands.emi.id", new Object[0]);
                    }
                    ResourceLocation id = new ResourceLocation(userInputStrings[2]);
                    EmiCommands.send(player, (byte)1, id);
                } else if (userInputStrings[1].equals("tree")) {
                    EmiCommands.send(player, (byte)2, null);
                }
            } else if (userInputStrings[0].equals("tree")) {
                if (userInputStrings[1].equals("goal")) {
                    if (userInputStrings[2].isEmpty()) {
                        throw new WrongUsageException("commands.emi.id", new Object[0]);
                    }
                    ResourceLocation id = new ResourceLocation(userInputStrings[2]);
                    EmiCommands.send(player, (byte)17, id);
                } else if (userInputStrings[1].equals("resolution")) {
                    if (userInputStrings[2].isEmpty()) {
                        throw new WrongUsageException("commands.emi.id", new Object[0]);
                    }
                    ResourceLocation id = new ResourceLocation(userInputStrings[2]);
                    EmiCommands.send(player, (byte)18, id);
                }
            }
        } else {
            throw new WrongUsageException("commands.emi.usage", new Object[0]);
        }
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public List addTabCompletionOptions(ICommandSender sender, String[] userInputStrings) {
        if (userInputStrings.length == 1) {
            return EmiCommands.getListOfStringsMatchingLastWord((String[])userInputStrings, (String[])new String[]{"view", "tree"});
        }
        if (userInputStrings.length == 2) {
            if (userInputStrings[0].equals("view")) {
                return EmiCommands.getListOfStringsMatchingLastWord((String[])userInputStrings, (String[])new String[]{"recipe", "tree"});
            }
            if (userInputStrings[0].equals("tree")) {
                return EmiCommands.getListOfStringsMatchingLastWord((String[])userInputStrings, (String[])new String[]{"goal", "resolution"});
            }
        }
        if (userInputStrings.length != 3 || !userInputStrings[1].equals("tree")) {
            // empty if block
        }
        return null;
    }

    private static void send(ServerPlayer player, byte type, @Nullable ResourceLocation id) {
        EmiNetwork.sendToClient(player, new CommandS2CPacket(type, id));
    }
}

