/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;

public class EmiRepairItemRecipe
extends EmiPatternCraftingRecipe {
    public static final List<Item> TOOLS = Arrays.stream(Item.itemsList).filter(i -> i != null && i.getIsRepairable(new ItemStack(i), new ItemStack(i))).collect(Collectors.toList());
    private final Item tool;

    public EmiRepairItemRecipe(Item tool, ResourceLocation id) {
        super(List.of(EmiStack.of(tool), EmiStack.of(tool)), EmiStack.of(tool), id);
        this.tool = tool;
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            List<ItemStack> items = this.getItems((Random)r);
            if (slot < 2) {
                return EmiStack.of(items.get(slot));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> EmiStack.of(this.getMergeItems((Random)r)), this.unique, x, y);
    }

    private List<ItemStack> getItems(Random random) {
        ArrayList items = Lists.newArrayList();
        items.add(this.getTool(random));
        items.add(this.getTool(random));
        return items;
    }

    private ItemStack getMergeItems(Random random) {
        List<ItemStack> items = this.getItems(random);
        ItemStack item = new ItemStack(this.tool);
        int maxDamage = this.tool.getMaxDamage(item);
        int damage = items.get(0).getItemDamage() - 21 * maxDamage / 20 + items.get(1).getItemDamage();
        if (damage > 0) {
            item.setItemDamage(damage);
        }
        return item;
    }

    private ItemStack getTool(Random r) {
        ItemStack stack = new ItemStack(this.tool);
        if (stack.getMaxDamage() <= 0) {
            return stack;
        }
        int d = r.nextInt(stack.getMaxDamage());
        stack.setItemDamage(d);
        return stack;
    }
}

