/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.NBTBase;
import net.minecraft.NBTTagCompound;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.item.DyeItem;
import shims.java.net.minecraft.util.DyeColor;

public class EmiFireworkStarRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::byColor).collect(Collectors.toList());
    private static final List<ItemStack> SHAPES = List.of(new ItemStack(Item.fireballCharge), new ItemStack(Item.feather), new ItemStack((Item)Item.goldNugget), new ItemStack(Item.skull, 1, 0), new ItemStack(Item.skull, 1, 1), new ItemStack(Item.skull, 1, 2), new ItemStack(Item.skull, 1, 3), new ItemStack(Item.skull, 1, 4));
    private static final List<Item> EFFECTS = List.of(Item.diamond, Item.glowstone);

    public EmiFireworkStarRecipe(ResourceLocation id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of(i)).collect(Collectors.toList())), EmiIngredient.of(SHAPES.stream().map(i -> EmiStack.of(i)).collect(Collectors.toList())), EmiIngredient.of(EFFECTS.stream().map(i -> EmiStack.of(i)).collect(Collectors.toList())), EmiStack.of(Item.gunpowder)), EmiStack.of(Item.fireworkCharge), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of(Item.gunpowder), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<ItemStack> items = this.getItems((Random)r);
            if (s < items.size()) {
                return EmiStack.of(items.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getFireworkStar, this.unique, x, y);
    }

    private List<DyeItem> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private List<ItemStack> getItems(Random random) {
        ArrayList items = Lists.newArrayList();
        int amount = random.nextInt(4);
        if (amount < 2) {
            items.add(new ItemStack(EFFECTS.get(amount)));
        } else if (amount == 2) {
            items.add(new ItemStack(EFFECTS.get(0)));
            items.add(new ItemStack(EFFECTS.get(1)));
        }
        amount = random.nextInt(10);
        if (amount < 8) {
            items.add(SHAPES.get(amount));
        }
        this.getDyes(random, 8 - items.size()).stream().map(DyeItem::toStack).forEach(items::add);
        return items;
    }

    private EmiStack getFireworkStar(Random random) {
        ItemStack stack = new ItemStack(Item.fireworkCharge);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound explosion = new NBTTagCompound();
        boolean hasShape = false;
        List<ItemStack> items = this.getItems(random);
        byte smallBall = 0;
        byte largeBall = 1;
        byte star = 2;
        byte creeper = 3;
        byte burst = 4;
        ArrayList colors = Lists.newArrayList();
        for (ItemStack item : items) {
            if (Item.glowstone.equals(item.getItem())) {
                explosion.setByte("Flicker", largeBall);
                continue;
            }
            if (Item.diamond.equals(item.getItem())) {
                explosion.setByte("Trail", largeBall);
                continue;
            }
            if (Item.fireballCharge.equals(item.getItem())) {
                explosion.setByte("Type", largeBall);
                hasShape = true;
                continue;
            }
            if (Item.goldNugget.equals(item.getItem())) {
                explosion.setByte("Type", star);
                hasShape = true;
                continue;
            }
            if (Item.feather.equals(item.getItem())) {
                explosion.setByte("Type", burst);
                hasShape = true;
                continue;
            }
            if (Item.skull.equals(item.getItem())) {
                explosion.setByte("Type", creeper);
                hasShape = true;
                continue;
            }
            colors.add(DyeColor.values()[1].getFireworkColor());
            colors.add(DyeColor.values()[item.getItemSubtype()].getFireworkColor());
        }
        if (!hasShape) {
            explosion.setByte("Type", smallBall);
        }
        explosion.setIntArray("Colors", colors.stream().mapToInt(Integer::intValue).toArray());
        tag.setTag("Explosion", (NBTBase)explosion);
        stack.setTagCompound(tag);
        return EmiStack.of(stack);
    }
}

