/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.NBTBase;
import net.minecraft.NBTTagCompound;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.item.DyeItem;
import shims.java.net.minecraft.util.DyeColor;

public class EmiFireworkStarFadeRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::byColor).collect(Collectors.toList());

    public EmiFireworkStarFadeRecipe(ResourceLocation id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of(i)).collect(Collectors.toList())), EmiStack.of(Item.fireworkCharge)), EmiStack.of(Item.fireworkCharge), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            EmiStack fireworkStar = this.getFireworkStar((Random)r, false);
            List<DyeItem> dyeItems = this.getDyes((Random)r, 8);
            int s = slot - 1;
            if (slot == 0) {
                return fireworkStar;
            }
            if (s < dyeItems.size()) {
                return EmiStack.of(dyeItems.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getFireworkStar((Random)r, true), this.unique, x, y);
    }

    private List<DyeItem> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private EmiStack getFireworkStar(Random random, Boolean faded) {
        ItemStack stack = new ItemStack(Item.fireworkCharge);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound explosion = new NBTTagCompound();
        int items = 0;
        int amount = random.nextInt(5);
        explosion.setByte("Type", (byte)amount);
        if (amount != 0) {
            ++items;
        }
        if ((amount = random.nextInt(4)) == 0) {
            explosion.setByte("Flicker", (byte)1);
            ++items;
        } else if (amount == 1) {
            explosion.setByte("Trail", (byte)1);
            ++items;
        } else if (amount == 2) {
            explosion.setByte("Trail", (byte)1);
            explosion.setByte("Flicker", (byte)1);
            items += 2;
        }
        List<DyeItem> dyeItems = this.getDyes(random, 8 - items);
        ArrayList colors = Lists.newArrayList();
        for (DyeItem dyeItem : dyeItems) {
            colors.add(dyeItem.color().getFireworkColor());
        }
        explosion.setIntArray("Colors", colors.stream().mapToInt(Integer::intValue).toArray());
        if (faded.booleanValue()) {
            List<DyeItem> dyeItemsFaded = this.getDyes(random, 8);
            ArrayList fadedColors = Lists.newArrayList();
            for (DyeItem dyeItem : dyeItemsFaded) {
                fadedColors.add(dyeItem.color().getFireworkColor());
            }
            explosion.setIntArray("FadeColors", fadedColors.stream().mapToInt(Integer::intValue).toArray());
        }
        tag.setTag("Explosion", (NBTBase)explosion);
        stack.setTagCompound(tag);
        return EmiStack.of(stack);
    }
}

