/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.NBTBase;
import net.minecraft.NBTTagCompound;
import net.minecraft.NBTTagList;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.item.DyeItem;
import shims.java.net.minecraft.util.DyeColor;

public class EmiFireworkRocketRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::byColor).collect(Collectors.toList());

    public EmiFireworkRocketRecipe(ResourceLocation id) {
        super(List.of(EmiStack.of(Item.paper), EmiStack.of(Item.fireworkCharge), EmiStack.of(Item.gunpowder)), EmiStack.of(Item.firework), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of(Item.paper), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<EmiStack> items = this.getItems((Random)r);
            if (s < items.size()) {
                return items.get(s);
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getFireworkRocket, this.unique, x, y);
    }

    private EmiStack getFireworkRocket(Random random) {
        ItemStack stack = new ItemStack(Item.firework);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound fireworks = new NBTTagCompound();
        NBTTagList explosions = new NBTTagList();
        List<EmiStack> items = this.getItems(random);
        int gunpowder = 0;
        for (EmiStack item : items) {
            if (item.getId() == EmiStack.of(Item.fireworkCharge).getId()) {
                explosions.appendTag((NBTBase)item.getNbt().getTagList("Explosion"));
                continue;
            }
            if (!item.isEqual(EmiStack.of(Item.gunpowder))) continue;
            ++gunpowder;
        }
        if (gunpowder > 1) {
            fireworks.setByte("Flight", (byte)gunpowder);
        }
        if (!items.isEmpty()) {
            fireworks.setTag("Explosions", (NBTBase)explosions);
        }
        tag.setTag("Fireworks", (NBTBase)fireworks);
        stack.setTagCompound(tag);
        return EmiStack.of(stack, 3L);
    }

    private List<EmiStack> getItems(Random random) {
        int i;
        ArrayList items = Lists.newArrayList();
        int amount = random.nextInt(3);
        for (i = 0; i <= amount; ++i) {
            items.add(EmiStack.of(Item.gunpowder));
        }
        amount = random.nextInt(8 - items.size());
        for (i = 0; i <= amount; ++i) {
            items.add(this.getFireworkStar(random));
        }
        return items;
    }

    private List<DyeItem> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private EmiStack getFireworkStar(Random random) {
        ItemStack stack = new ItemStack(Item.fireworkCharge);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound explosion = new NBTTagCompound();
        int items = 0;
        int amount = random.nextInt(5);
        explosion.setByte("Type", (byte)amount);
        if (amount != 0) {
            ++items;
        }
        if ((amount = random.nextInt(4)) == 0) {
            explosion.setByte("Flicker", (byte)1);
            ++items;
        } else if (amount == 1) {
            explosion.setByte("Trail", (byte)1);
            ++items;
        } else if (amount == 2) {
            explosion.setByte("Trail", (byte)1);
            explosion.setByte("Flicker", (byte)1);
            items += 2;
        }
        List<DyeItem> dyeItems = this.getDyes(random, 8 - items);
        ArrayList colors = Lists.newArrayList();
        for (DyeItem dyeItem : dyeItems) {
            colors.add(dyeItem.color().getFireworkColor());
        }
        explosion.setIntArray("Colors", colors.stream().mapToInt(Integer::intValue).toArray());
        amount = random.nextInt(2);
        if (amount == 1) {
            List<DyeItem> dyeItemsFaded = this.getDyes(random, 8);
            ArrayList fadedColors = Lists.newArrayList();
            for (DyeItem dyeItem : dyeItemsFaded) {
                fadedColors.add(dyeItem.color().getFireworkColor());
            }
            explosion.setIntArray("FadeColors", fadedColors.stream().mapToInt(Integer::intValue).toArray());
        }
        tag.setTag("Explosion", (NBTBase)explosion);
        stack.setTagCompound(tag);
        return EmiStack.of(stack);
    }
}

