/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Item;
import net.minecraft.ItemArmor;
import net.minecraft.ItemStack;
import net.minecraft.Material;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.item.DyeItem;
import shims.java.net.minecraft.item.DyeableItem;
import shims.java.net.minecraft.util.DyeColor;

public class EmiArmorDyeRecipe
extends EmiPatternCraftingRecipe {
    public static final List<Item> DYEABLE_ITEMS = Arrays.stream(Item.itemsList).filter(i -> i != null).filter(i -> {
        ItemArmor a;
        return i instanceof ItemArmor && (a = (ItemArmor)i).getArmorMaterial() == Material.leather;
    }).toList();
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(c -> DyeItem.byColor(c)).toList();
    private final Item armor;

    public EmiArmorDyeRecipe(Item armor, ResourceLocation id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of(i)).collect(Collectors.toList())), EmiStack.of(armor)), EmiStack.of(armor), id);
        this.armor = armor;
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of(this.armor), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<DyeItem> dyes = this.getDyes((Random)r);
            if (s < dyes.size()) {
                return EmiStack.of(dyes.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> EmiStack.of(DyeableItem.blendAndSetColor(new ItemStack(this.armor), this.getDyes((Random)r))), this.unique, x, y);
    }

    private List<DyeItem> getDyes(Random random) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(8);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }
}

