/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.Item;
import net.minecraft.ItemArmor;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;

public class EmiAnvilRepairItemRecipe
implements EmiRecipe {
    private final Item tool;
    private final ResourceLocation id;
    private final int uniq = EmiUtil.RANDOM.nextInt();

    public EmiAnvilRepairItemRecipe(Item tool, ResourceLocation id) {
        this.tool = tool;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.ANVIL_REPAIRING;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of(this.tool), EmiStack.of(this.tool));
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of(this.tool));
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 125;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        int notUniq = this.uniq;
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 0), notUniq, 0, 0);
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 1), notUniq, 49, 0);
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 2), notUniq, 107, 0).recipeContext(this);
    }

    protected EmiStack getItem(Random random, int item) {
        ArrayList items = Lists.newArrayList();
        items.add(this.getTool(random));
        items.add(this.getToolRepairItem());
        items.add(this.getMergeItems(items));
        return EmiStack.of((ItemStack)items.get(item));
    }

    private ItemStack getMergeItems(List<ItemStack> items) {
        int damage;
        ItemStack item = this.tool.getItemStackForStatsIcon();
        if (item.getRepairItem() != null && (damage = !(item.getItem() instanceof ItemArmor) ? items.get(0).getItemDamage() - (int)(items.get((int)0).getMaterialForRepairs().durability * 200.0f) : items.get(0).getItemDamage() - (int)items.get((int)0).getMaterialForRepairs().durability) > 0) {
            item.setItemDamage(damage);
        }
        return item;
    }

    private ItemStack getTool(Random r) {
        ItemStack stack = new ItemStack(this.tool);
        int d = r.nextInt(Math.abs(stack.getMaxDamage()));
        stack.setItemDamage(d);
        return stack;
    }

    private ItemStack getToolRepairItem() {
        ItemStack stack = new ItemStack(this.tool);
        if (stack.getRepairItem() != null) {
            return stack.getRepairItem().getItemStackForStatsIcon();
        }
        return stack;
    }
}

