/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.Enchantment;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.NBTBase;
import net.minecraft.NBTTagCompound;
import net.minecraft.NBTTagList;
import net.minecraft.ResourceLocation;

public class EmiAnvilEnchantRecipe
implements EmiRecipe {
    public static final List<Enchantment> ENCHANTMENTS = Arrays.stream(Enchantment.enchantmentsList).filter(e -> e != null).toList();
    private final Item tool;
    private final Enchantment enchantment;
    private final int level;
    private final ResourceLocation id;

    public EmiAnvilEnchantRecipe(Item tool, Enchantment enchantment, int level, ResourceLocation id) {
        this.tool = tool;
        this.enchantment = enchantment;
        this.level = level;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.ANVIL_REPAIRING;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of(this.tool), this.getBook());
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of(this.tool));
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 125;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        widgets.addSlot(EmiStack.of(this.tool), 0, 0);
        widgets.addSlot(this.getBook(), 49, 0);
        widgets.addSlot(EmiStack.of(this.getTool()), 107, 0).recipeContext(this);
    }

    private ItemStack getTool() {
        ItemStack itemStack = new ItemStack(this.tool);
        itemStack.addEnchantment(this.enchantment, this.level);
        return itemStack;
    }

    private EmiStack getBook() {
        ItemStack item = new ItemStack((Item)Item.enchantedBook);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList StoredEnchantments = new NBTTagList();
        NBTTagCompound enchant = new NBTTagCompound();
        short id = ((NBTTagCompound)this.getTool().getTagCompound().getTagList("ench").tagAt(0)).getShort("id");
        enchant.setShort("id", id);
        enchant.setShort("lvl", (short)this.level);
        StoredEnchantments.appendTag((NBTBase)enchant);
        tag.setTag("StoredEnchantments", (NBTBase)StoredEnchantments);
        item.setTagCompound(tag);
        return EmiStack.of(item);
    }
}

