/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;

public class EmiBrewingRecipe
implements EmiRecipe {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("minecraft", "textures/gui/container/brewing_stand.png");
    private final EmiIngredient input;
    private final EmiIngredient ingredient;
    private final EmiStack output;
    private final EmiStack input3;
    private final EmiStack output3;
    private final ResourceLocation id;

    public EmiBrewingRecipe(EmiStack input, EmiIngredient ingredient, EmiStack output, ResourceLocation id) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
        this.input3 = input.copy().setAmount(3L);
        this.output3 = output.copy().setAmount(3L);
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.BREWING;
    }

    @Override
    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(this.input3, this.ingredient);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(this.output3);
    }

    @Override
    public int getDisplayWidth() {
        return 64;
    }

    @Override
    public int getDisplayHeight() {
        return 55;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 64, 55, 55, 15);
        widgets.addAnimatedTexture(BACKGROUND, 42, 0, 9, 28, 176, 0, 20000, false, false, false).tooltip((mx, my) -> List.of(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("emi.cooking.time", 20)))));
        widgets.addAnimatedTexture(BACKGROUND, 10, -1, 12, 29, 185, 0, 700, false, true, false);
        widgets.addSlot(this.input, 0, 30).drawBack(false);
        widgets.addSlot(this.ingredient, 23, 1).drawBack(false);
        widgets.addSlot(this.output, 46, 30).drawBack(false).recipeContext(this);
    }
}

