/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import com.google.common.collect.Lists;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.runtime.EmiLog;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Container;
import net.minecraft.EntityPlayer;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;
import net.minecraft.Slot;
import org.jetbrains.annotations.Nullable;
import shims.java.com.unascribed.retroemi.ItemStacks;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.network.PacketByteBuf;

public class FillRecipeC2SPacket
implements EmiPacket {
    private final int syncId;
    private final int action;
    private final List<Integer> slots;
    private final List<Integer> crafting;
    private final int output;
    private final List<ItemStack> stacks;

    public FillRecipeC2SPacket(Container handler, int action, List<Slot> slots, List<Slot> crafting, @Nullable Slot output, List<ItemStack> stacks) {
        this.syncId = handler.windowId;
        this.action = action;
        this.slots = slots.stream().map(s -> s == null ? -1 : s.slotNumber).collect(Collectors.toList());
        this.crafting = crafting.stream().map(s -> s == null ? -1 : s.slotNumber).collect(Collectors.toList());
        this.output = output == null ? -1 : output.slotNumber;
        this.stacks = stacks;
    }

    public FillRecipeC2SPacket(PacketByteBuf buf) {
        this.syncId = buf.readInt();
        this.action = buf.readByte();
        this.slots = FillRecipeC2SPacket.parseCompressedSlots(buf);
        this.crafting = Lists.newArrayList();
        int craftingSize = buf.readVarInt();
        for (int i = 0; i < craftingSize; ++i) {
            int s = buf.readVarInt();
            this.crafting.add(s);
        }
        this.output = buf.readBoolean() ? buf.readVarInt() : -1;
        int size = buf.readVarInt();
        this.stacks = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.stacks.add(buf.readItemStack());
        }
    }

    @Override
    public void write(PacketByteBuf buf) {
        buf.writeInt(this.syncId);
        buf.writeByte(this.action);
        FillRecipeC2SPacket.writeCompressedSlots(this.slots, buf);
        buf.writeVarInt(this.crafting.size());
        for (Integer s : this.crafting) {
            buf.writeVarInt(s);
        }
        if (this.output != -1) {
            buf.writeBoolean(true);
            buf.writeVarInt(this.output);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeVarInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            buf.writeItemStack(stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(EntityPlayer player) {
        if (this.slots == null || this.crafting == null) {
            EmiLog.error("Client requested fill but passed input and crafting slot information was invalid, aborting");
            return;
        }
        Container handler = player.openContainer;
        if (handler == null || handler.windowId != this.syncId) {
            EmiLog.warn("Client requested fill but screen handler has changed, aborting");
            return;
        }
        ArrayList slots = Lists.newArrayList();
        ArrayList crafting = Lists.newArrayList();
        Slot output = null;
        for (int i : this.slots) {
            if (i < 0 || i >= handler.inventorySlots.size()) {
                EmiLog.error("Client requested fill but passed input slots don't exist, aborting");
                return;
            }
            slots.add(handler.getSlot(i));
        }
        for (int i : this.crafting) {
            if (i >= 0 && i < handler.inventorySlots.size()) {
                crafting.add(handler.getSlot(i));
                continue;
            }
            crafting.add(null);
        }
        if (this.output != -1 && this.output >= 0 && this.output < handler.inventorySlots.size()) {
            output = handler.getSlot(this.output);
        }
        if (crafting.size() >= this.stacks.size()) {
            int i;
            ArrayList rubble = Lists.newArrayList();
            for (i = 0; i < crafting.size(); ++i) {
                Slot s = (Slot)crafting.get(i);
                if (s == null || !s.canTakeStack(player) || ItemStacks.isEmpty(s.getStack())) continue;
                rubble.add(s.getStack().copy());
                s.putStack(ItemStacks.EMPTY);
            }
            try {
                for (i = 0; i < this.stacks.size(); ++i) {
                    ItemStack stack = this.stacks.get(i);
                    if (ItemStacks.isEmpty(stack)) continue;
                    int gotten = FillRecipeC2SPacket.grabMatching(player, slots, rubble, crafting, stack);
                    if (gotten != stack.stackSize) {
                        if (gotten > 0) {
                            stack.stackSize = gotten;
                            RetroEMI.offerOrDrop(player, stack);
                        }
                        return;
                    }
                    Slot s = (Slot)crafting.get(i);
                    if (s != null && s.isItemValid(stack) && stack.stackSize <= s.getSlotStackLimit() && stack.stackSize <= stack.getMaxStackSize()) {
                        s.putStack(stack);
                        continue;
                    }
                    RetroEMI.offerOrDrop(player, stack);
                }
                if (output != null) {
                    if (this.action == 1) {
                        handler.slotClick(output.slotNumber, 0, 0, false, player);
                    } else if (this.action == 2) {
                        handler.slotClick(output.slotNumber, 0, 1, false, player);
                    }
                }
            }
            finally {
                for (ItemStack stack : rubble) {
                    RetroEMI.offerOrDrop(player, stack);
                }
            }
        }
    }

    private static List<Integer> parseCompressedSlots(PacketByteBuf buf) {
        ArrayList list = Lists.newArrayList();
        int amount = buf.readVarInt();
        for (int i = 0; i < amount; ++i) {
            int low = buf.readVarInt();
            int high = buf.readVarInt();
            if (low < 0) {
                return null;
            }
            for (int j = low; j <= high; ++j) {
                list.add(j);
            }
        }
        return list;
    }

    private static void writeCompressedSlots(List<Integer> list, PacketByteBuf buf) {
        ArrayList postWrite = Lists.newArrayList();
        int groups = 0;
        int i = 0;
        while (i < list.size()) {
            ++groups;
            int start = i;
            int startValue = list.get(start);
            while (i < list.size() && i - start == list.get(i) - startValue) {
                ++i;
            }
            int end = i - 1;
            postWrite.add(b -> {
                b.writeVarInt(startValue);
                b.writeVarInt((Integer)list.get(end));
            });
        }
        buf.writeVarInt(groups);
        for (Consumer consumer : postWrite) {
            consumer.accept(buf);
        }
    }

    private static int grabMatching(EntityPlayer player, List<Slot> slots, List<ItemStack> rubble, List<Slot> crafting, ItemStack stack) {
        int amount = stack.stackSize;
        int grabbed = 0;
        for (int i = 0; i < rubble.size(); ++i) {
            if (grabbed >= amount) {
                return grabbed;
            }
            ItemStack r = rubble.get(i);
            if (!RetroEMI.canCombine(stack, r)) continue;
            int wanted = amount - grabbed;
            if (r.stackSize <= wanted) {
                grabbed += r.stackSize;
                rubble.remove(i);
                --i;
                continue;
            }
            grabbed = amount;
            r.stackSize -= wanted;
        }
        for (Slot s : slots) {
            ItemStack st;
            if (grabbed >= amount) {
                return grabbed;
            }
            if (crafting.contains(s) || !s.canTakeStack(player) || !RetroEMI.canCombine(stack, st = s.getStack())) continue;
            int wanted = amount - grabbed;
            if (st.stackSize <= wanted) {
                grabbed += st.stackSize;
                s.putStack(ItemStacks.EMPTY);
                continue;
            }
            grabbed = amount;
            st.stackSize -= wanted;
        }
        return grabbed;
    }

    @Override
    public ResourceLocation getId() {
        return EmiNetwork.FILL_RECIPE;
    }
}

