/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import dev.emi.emi.chess.EmiChess;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import net.minecraft.EntityPlayer;
import net.minecraft.ResourceLocation;
import net.minecraft.ServerPlayer;
import shims.java.net.minecraft.network.PacketByteBuf;

public abstract class EmiChessPacket
implements EmiPacket {
    protected final String uuid;
    protected final byte type;
    protected final byte start;
    protected final byte end;

    public EmiChessPacket(String uuid, byte type, byte start, byte end) {
        this.uuid = uuid;
        this.type = type;
        this.start = start;
        this.end = end;
    }

    public EmiChessPacket(PacketByteBuf buf) {
        this(buf.readString(), buf.readByte(), buf.readByte(), buf.readByte());
    }

    @Override
    public void write(PacketByteBuf buf) {
        buf.writeString(this.uuid);
        buf.writeByte(this.type);
        buf.writeByte(this.start);
        buf.writeByte(this.end);
    }

    @Override
    public ResourceLocation getId() {
        return EmiNetwork.CHESS;
    }

    public static class C2S
    extends EmiChessPacket {
        public C2S(String uuid, byte type, byte start, byte end) {
            super(uuid, type, start, end);
        }

        public C2S(PacketByteBuf buf) {
            super(buf);
        }

        @Override
        public void apply(EntityPlayer player) {
            EntityPlayer opponent = player.worldObj.getPlayerEntityByName(this.uuid);
            if (opponent instanceof ServerPlayer) {
                ServerPlayer spe = (ServerPlayer)opponent;
                EmiNetwork.sendToClient(spe, new S2C(player.getCommandSenderName(), this.type, this.start, this.end));
            }
        }
    }

    public static class S2C
    extends EmiChessPacket {
        public S2C(String uuid, byte type, byte start, byte end) {
            super(uuid, type, start, end);
        }

        public S2C(PacketByteBuf buf) {
            super(buf);
        }

        @Override
        public void apply(EntityPlayer player) {
            EmiChess.receiveNetwork(this.uuid, this.type, this.start, this.end);
        }
    }
}

