/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.runtime.EmiLog;
import net.minecraft.EntityPlayer;
import net.minecraft.ItemStack;
import net.minecraft.Packet;
import net.minecraft.Packet103SetSlot;
import net.minecraft.ResourceLocation;
import net.minecraft.ServerPlayer;
import shims.java.com.unascribed.retroemi.ItemStacks;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.network.PacketByteBuf;

public class CreateItemC2SPacket
implements EmiPacket {
    private final int mode;
    private final ItemStack stack;

    public CreateItemC2SPacket(int mode, ItemStack stack) {
        this.mode = mode;
        this.stack = stack;
    }

    public CreateItemC2SPacket(PacketByteBuf buf) {
        this(buf.readByte(), buf.readItemStack());
    }

    @Override
    public void write(PacketByteBuf buf) {
        buf.writeByte(this.mode);
        buf.writeItemStack(this.stack);
    }

    @Override
    public void apply(EntityPlayer player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer esp = (ServerPlayer)player;
            if ((esp.mcServer.getConfigurationManager().isPlayerOpped(esp.getCommandSenderName()) || player.capabilities.isCreativeMode) && player.openContainer != null) {
                if (ItemStacks.isEmpty(this.stack)) {
                    if (this.mode == 1) {
                        player.inventory.setItemStack(null);
                    }
                } else {
                    EmiLog.info(player.getEntityName() + " cheated in " + this.stack);
                    if (this.mode == 0) {
                        RetroEMI.offerOrDrop(player, this.stack);
                    } else if (this.mode == 1) {
                        player.inventory.setItemStack(this.stack);
                        esp.playerNetServerHandler.sendPacketToPlayer((Packet)new Packet103SetSlot(-1, 0, this.stack));
                    }
                }
            }
        }
    }

    @Override
    public ResourceLocation getId() {
        return EmiNetwork.CREATE_ITEM;
    }
}

