/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import net.minecraft.EntityPlayer;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.network.PacketByteBuf;

public class CommandS2CPacket
implements EmiPacket {
    private final byte type;
    private final ResourceLocation id;

    public CommandS2CPacket(byte type, ResourceLocation id) {
        this.type = type;
        this.id = id;
    }

    public CommandS2CPacket(PacketByteBuf buf) {
        this.type = buf.readByte();
        if (this.type == 1 || this.type == 17 || this.type == 18) {
            String path = buf.readString();
            String domain = buf.readString();
            this.id = new ResourceLocation(path, domain);
        } else {
            this.id = null;
        }
    }

    @Override
    public void write(PacketByteBuf buf) {
        buf.writeByte(this.type);
        if (this.type == 1 || this.type == 17 || this.type == 18) {
            buf.writeString(this.id.getResourcePath());
            buf.writeString(this.id.getResourceDomain());
        }
    }

    @Override
    public void apply(EntityPlayer player) {
        EmiRecipe recipe;
        if (this.type == 1) {
            EmiRecipe recipe2 = EmiApi.getRecipeManager().getRecipe(this.id);
            if (recipe2 != null) {
                EmiApi.displayRecipe(recipe2);
            }
        } else if (this.type == 2) {
            EmiApi.viewRecipeTree();
        } else if (this.type == 17) {
            EmiRecipe recipe3 = EmiApi.getRecipeManager().getRecipe(this.id);
            if (recipe3 != null) {
                BoM.setGoal(recipe3);
            }
        } else if (this.type == 18 && (recipe = EmiApi.getRecipeManager().getRecipe(this.id)) != null && BoM.tree != null) {
            for (EmiStack stack : recipe.getOutputs()) {
                BoM.tree.addResolution(stack, recipe);
            }
        }
    }

    @Override
    public ResourceLocation getId() {
        return EmiNetwork.COMMAND;
    }
}

