/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.input;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.input.EmiInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shims.java.net.minecraft.client.util.InputUtil;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Formatting;

public class EmiBind {
    public static final EmiBind LEFT_CLICK = new EmiBind("", new ModifiedKey(InputUtil.Type.MOUSE.createFromCode(0), 0));
    public static final int MAX_BINDS = 4;
    public final String translationKey;
    public final List<ModifiedKey> defaultKeys;
    public List<ModifiedKey> boundKeys;

    public EmiBind(String translationKey, int code) {
        this(translationKey, 0, code);
    }

    public EmiBind(String translationKey, int modifiers, int code) {
        this(translationKey, ModifiedKey.of(code, modifiers));
    }

    public EmiBind(String translationKey, ModifiedKey ... defaultKeys) {
        this.translationKey = translationKey;
        this.defaultKeys = Arrays.asList(defaultKeys);
        this.boundKeys = this.defaultKeys.stream().collect(Collectors.toCollection(ArrayList::new));
        this.updateBinds();
    }

    public void updateBinds() {
        if (this.boundKeys.size() == 0) {
            this.boundKeys.add(new ModifiedKey(InputUtil.UNKNOWN_KEY, 0));
        }
        for (int i = 0; i < this.boundKeys.size() - 1; ++i) {
            if (!this.boundKeys.get(i).isUnbound()) continue;
            this.boundKeys.remove(i);
            --i;
        }
        if (!this.boundKeys.get(this.boundKeys.size() - 1).isUnbound() && this.boundKeys.size() < 4) {
            this.boundKeys.add(new ModifiedKey(InputUtil.UNKNOWN_KEY, 0));
        }
    }

    public boolean isBound() {
        return this.boundKeys.size() > 0 && !this.boundKeys.get(0).isUnbound();
    }

    public Text getBindText() {
        if (!this.isBound()) {
            return EmiPort.literal("[]", Formatting.GOLD);
        }
        ModifiedKey bind = this.boundKeys.get(0);
        for (ModifiedKey key : this.boundKeys) {
            if (key.key.getCategory() != InputUtil.Type.MOUSE) continue;
            bind = key;
            break;
        }
        return EmiPort.literal("[", Formatting.GOLD).append(bind.getKeyText(Formatting.GOLD)).append(EmiPort.literal("]", Formatting.GOLD));
    }

    public void setToDefault() {
        this.boundKeys = this.defaultKeys.stream().collect(Collectors.toCollection(ArrayList::new));
        this.updateBinds();
    }

    public void setBinds(ModifiedKey ... keys) {
        this.boundKeys = Stream.of(keys).collect(Collectors.toCollection(ArrayList::new));
        this.updateBinds();
    }

    public void setBind(int offset, ModifiedKey key) {
        if (offset < this.boundKeys.size() && offset >= 0) {
            this.boundKeys.set(offset, key);
        }
        this.updateBinds();
    }

    public boolean isHeld() {
        for (ModifiedKey boundKey : this.boundKeys) {
            if (EmiInput.getCurrentModifiers() != boundKey.modifiersToMatch() || boundKey.key.getCategory() != InputUtil.Type.KEYSYM || boundKey.key.getCode() == -1 || !InputUtil.isKeyPressed(boundKey.key.getCode())) continue;
            return true;
        }
        return false;
    }

    public boolean matchesKey(int keyCode, int scanCode) {
        for (ModifiedKey boundKey : this.boundKeys) {
            if (EmiInput.getCurrentModifiers() != boundKey.modifiersToMatch() || !(keyCode == InputUtil.UNKNOWN_KEY.getCode() ? boundKey.key.getCategory() == InputUtil.Type.SCANCODE && boundKey.key.getCode() == scanCode : boundKey.key.getCategory() == InputUtil.Type.KEYSYM && boundKey.key.getCode() == keyCode)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesMouse(int code) {
        for (ModifiedKey boundKey : this.boundKeys) {
            if (EmiInput.getCurrentModifiers() != boundKey.modifiersToMatch() || boundKey.key.getCategory() != InputUtil.Type.MOUSE || boundKey.key.getCode() != code) continue;
            return true;
        }
        return false;
    }

    public void setKey(List<String> keys) {
        ArrayList modifiedKeys = Lists.newArrayList();
        for (String string : keys) {
            String[] parts = string.split(" ");
            InputUtil.Key key = InputUtil.UNKNOWN_KEY;
            int modifiers = 0;
            if (parts.length > 0) {
                key = InputUtil.fromTranslationKey(parts[parts.length - 1]);
                for (int i = 0; i < parts.length - 1; ++i) {
                    if (parts[i].equals("ctrl") || parts[i].equals("control")) {
                        modifiers |= 1;
                        continue;
                    }
                    if (parts[i].equals("alt")) {
                        modifiers |= 2;
                        continue;
                    }
                    if (!parts[i].equals("shift")) continue;
                    modifiers |= 4;
                }
            }
            modifiedKeys.add(new ModifiedKey(key, modifiers));
        }
        this.boundKeys = modifiedKeys;
        this.updateBinds();
    }

    public record ModifiedKey(InputUtil.Key key, int modifiers) {
        public static ModifiedKey of(int code, int modifiers) {
            return new ModifiedKey(InputUtil.Type.KEYSYM.createFromCode(code), modifiers);
        }

        public String toName() {
            Object name = "";
            if ((this.modifiers & 1) > 0) {
                name = (String)name + "ctrl ";
            }
            if ((this.modifiers & 2) > 0) {
                name = (String)name + "alt ";
            }
            if ((this.modifiers & 4) > 0) {
                name = (String)name + "shift ";
            }
            name = (String)name + this.key.getTranslationKey();
            return name;
        }

        public int modifiersToMatch() {
            int modifiers = this.modifiers;
            if (this.key.getCategory() == InputUtil.Type.KEYSYM) {
                modifiers ^= EmiInput.maskFromCode(this.key.getCode());
            }
            return modifiers;
        }

        public boolean isUnbound() {
            return this.key == InputUtil.UNKNOWN_KEY;
        }

        public MutableText getKeyText(Formatting formatting) {
            MutableText text = EmiPort.literal("", formatting);
            this.appendModifiers(text, this.modifiers());
            EmiPort.append(text, this.key().getLocalizedText());
            return text;
        }

        private void appendModifiers(MutableText text, int modifiers) {
            if ((modifiers & 1) > 0) {
                EmiPort.append(text, EmiPort.translatable("key.keyboard.control"));
                EmiPort.append(text, EmiPort.literal(" + "));
            }
            if ((modifiers & 2) > 0) {
                EmiPort.append(text, EmiPort.translatable("key.keyboard.alt"));
                EmiPort.append(text, EmiPort.literal(" + "));
            }
            if ((modifiers & 4) > 0) {
                EmiPort.append(text, EmiPort.translatable("key.keyboard.shift"));
                EmiPort.append(text, EmiPort.literal(" + "));
            }
        }
    }
}

