/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.handler;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import moddedmite.emi.api.EMIInventoryCrafting;
import net.minecraft.Container;
import net.minecraft.ContainerPlayer;
import net.minecraft.ContainerWorkbench;
import net.minecraft.Slot;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.text.Text;

public class InventoryRecipeHandler
implements StandardRecipeHandler<ContainerPlayer> {
    public static final Text TOO_SMALL = EmiPort.translatable("emi.too_small");

    @Override
    public List<Slot> getInputSources(ContainerPlayer handler) {
        int invStart;
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 5; ++i) {
            list.add(handler.getSlot(i));
        }
        for (int i = invStart = 9; i < invStart + 36; ++i) {
            list.add(handler.getSlot(i));
        }
        return list;
    }

    @Override
    public List<Slot> getCraftingSlots(ContainerPlayer handler) {
        ArrayList list = Lists.newArrayList();
        list.add(handler.getSlot(1));
        list.add(handler.getSlot(2));
        list.add(null);
        list.add(handler.getSlot(3));
        list.add(handler.getSlot(4));
        list.add(null);
        list.add(null);
        list.add(null);
        list.add(null);
        return list;
    }

    @Override
    public List<Slot> getCraftingSlots(EmiRecipe recipe, ContainerPlayer handler) {
        if (recipe instanceof EmiCraftingRecipe) {
            EmiCraftingRecipe craf = (EmiCraftingRecipe)recipe;
            if (craf.shapeless) {
                ArrayList list = Lists.newArrayList();
                list.add(handler.getSlot(1));
                list.add(handler.getSlot(2));
                list.add(handler.getSlot(3));
                list.add(handler.getSlot(4));
                return list;
            }
        }
        return this.getCraftingSlots(handler);
    }

    @Override
    @Nullable
    public Slot getOutputSlot(ContainerPlayer handler) {
        return (Slot)handler.inventorySlots.get(0);
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree()) {
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe crafting = (EmiCraftingRecipe)recipe;
                return crafting.canFit(2, 2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<ContainerPlayer> context) {
        ContainerPlayer sh = context.getScreenHandler();
        return this.canFit((Container)sh, recipe) && StandardRecipeHandler.super.canCraft(recipe, context);
    }

    private boolean canFit(Container sh, EmiRecipe recipe) {
        ContainerWorkbench arsh;
        int w = 0;
        int h = 0;
        EmiCraftingRecipe ecr = null;
        if (sh instanceof ContainerWorkbench) {
            arsh = (ContainerWorkbench)sh;
            w = ((EMIInventoryCrafting)arsh.craft_matrix).getInventoryWidth();
            h = arsh.craft_matrix.getSizeInventory() / ((EMIInventoryCrafting)arsh.craft_matrix).getInventoryWidth();
        }
        if (sh instanceof ContainerPlayer) {
            arsh = (ContainerPlayer)sh;
            w = ((EMIInventoryCrafting)arsh.craft_matrix).getInventoryWidth();
            h = arsh.craft_matrix.getSizeInventory() / ((EMIInventoryCrafting)arsh.craft_matrix).getInventoryWidth();
        }
        if (recipe instanceof EmiCraftingRecipe) {
            EmiCraftingRecipe crafting;
            ecr = crafting = (EmiCraftingRecipe)recipe;
        }
        if (ecr != null) {
            return ecr.canFit(w, h);
        }
        return false;
    }

    @Override
    public List<TooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<ContainerPlayer> context) {
        ContainerPlayer sh;
        if (!this.canCraft(recipe, context) && !this.canFit((Container)(sh = context.getScreenHandler()), recipe)) {
            return List.of(TooltipComponent.of(EmiPort.ordered(TOO_SMALL)));
        }
        return StandardRecipeHandler.super.getTooltip(recipe, context);
    }
}

