/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.handler;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import moddedmite.emi.api.EMIInventoryCrafting;
import moddedmite.emi.api.EMISlot;
import moddedmite.emi.api.EMISlotCrafting;
import net.minecraft.Container;
import net.minecraft.EntityPlayer;
import net.minecraft.IInventory;
import net.minecraft.InventoryCrafting;
import net.minecraft.Minecraft;
import net.minecraft.Slot;
import net.minecraft.SlotCrafting;

public class CoercedRecipeHandler<T extends Container>
implements StandardRecipeHandler<T> {
    private SlotCrafting output;
    private IInventory inv;

    public CoercedRecipeHandler(SlotCrafting output) {
        this.output = output;
        this.inv = ((EMISlotCrafting)output).getCraftMatrix();
    }

    @Override
    public Slot getOutputSlot(Container handler) {
        return this.output;
    }

    @Override
    public List<Slot> getInputSources(Container handler) {
        Minecraft client = Minecraft.getMinecraft();
        ArrayList slots = Lists.newArrayList();
        if (this.output != null) {
            for (Slot slot : handler.inventorySlots) {
                if (!slot.canTakeStack((EntityPlayer)client.thePlayer) || slot == this.output) continue;
                slots.add(slot);
            }
        }
        return slots;
    }

    @Override
    public List<Slot> getCraftingSlots(Container handler) {
        int n;
        ArrayList slots = Lists.newArrayList();
        IInventory iInventory = this.inv;
        if (iInventory instanceof InventoryCrafting) {
            InventoryCrafting ic = (InventoryCrafting)iInventory;
            n = ((EMIInventoryCrafting)ic).getInventoryWidth();
        } else {
            n = 3;
        }
        int width = n;
        int height = this.inv.getSizeInventory() / width;
        for (int i = 0; i < 9; ++i) {
            slots.add(null);
        }
        for (Slot slot : handler.inventorySlots) {
            if (slot.inventory != this.inv || ((EMISlot)slot).getSlotIndex() >= width * height || ((EMISlot)slot).getSlotIndex() < 0) continue;
            int index = ((EMISlot)slot).getSlotIndex();
            index = index * 3 / width;
            slots.set(index, slot);
        }
        return slots;
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree()) {
            if (recipe instanceof EmiCraftingRecipe) {
                int n;
                EmiCraftingRecipe crafting = (EmiCraftingRecipe)recipe;
                IInventory iInventory = this.inv;
                if (iInventory instanceof InventoryCrafting) {
                    InventoryCrafting ic = (InventoryCrafting)iInventory;
                    n = ((EMIInventoryCrafting)ic).getInventoryWidth();
                } else {
                    n = 3;
                }
                int width = n;
                int height = this.inv.getSizeInventory() / width;
                return crafting.canFit(width, height);
            }
            return true;
        }
        return false;
    }
}

