/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import moddedmite.emi.util.MinecraftServerHelper;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;

public class RecipeDefaults {
    public final List<ResourceLocation> added = Lists.newArrayList();
    public final List<Resolution> resolutions = Lists.newArrayList();
    public final List<Tag> tags = Lists.newArrayList();

    public void add(ResourceLocation id) {
        this.added.add(id);
    }

    public void add(ResourceLocation id, JsonArray arr) {
        ArrayList<JsonArray> array = new ArrayList<JsonArray>(Collections.singleton(arr));
        this.resolutions.add(new Resolution(id, array));
    }

    public void addTag(JsonElement tag, JsonElement stack) {
        this.tags.add(new Tag(tag, stack));
    }

    public void remove(ResourceLocation id) {
        this.added.remove(id);
        this.resolutions.removeIf(r -> r.recipe.equals((Object)id));
    }

    public void clear() {
        this.added.clear();
        this.resolutions.clear();
        this.tags.clear();
    }

    public Map<EmiIngredient, EmiRecipe> bake() {
        EmiRecipe recipe;
        HashMap map = Maps.newHashMap();
        if (!MinecraftServerHelper.isServer()) {
            Minecraft client = Minecraft.getMinecraft();
            if (client.theWorld == null) {
                return map;
            }
        }
        EmiRecipeManager manager = EmiApi.getRecipeManager();
        for (ResourceLocation id : this.added) {
            recipe = manager.getRecipe(id);
            if (recipe == null) continue;
            for (EmiIngredient emiIngredient : recipe.getOutputs()) {
                map.put(emiIngredient, recipe);
            }
        }
        for (Resolution r : this.resolutions) {
            recipe = manager.getRecipe(r.recipe);
            if (recipe == null) continue;
            for (JsonElement jsonElement : r.stacks) {
                EmiIngredient stack = EmiIngredientSerializer.getDeserialized(jsonElement);
                if (stack.isEmpty()) continue;
                map.put(stack, recipe);
            }
        }
        for (Tag t : this.tags) {
            EmiIngredient tag = EmiIngredientSerializer.getDeserialized(t.tag);
            EmiIngredient stack = EmiIngredientSerializer.getDeserialized(t.stack);
            if (tag.isEmpty() || stack.isEmpty() || stack.getEmiStacks().size() != 1 || !new HashSet<EmiStack>(tag.getEmiStacks()).containsAll(stack.getEmiStacks())) continue;
            map.put(tag, new EmiResolutionRecipe(tag, stack.getEmiStacks().get(0)));
        }
        return map;
    }

    public record Resolution(ResourceLocation recipe, List<JsonElement> stacks) {
    }

    public record Tag(JsonElement tag, JsonElement stack) {
    }
}

