/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.data.RecipeDefaults;
import dev.emi.emi.runtime.EmiLog;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.Resource;
import net.minecraft.ResourceLocation;
import net.minecraft.ResourceManager;
import net.minecraft.ResourceManagerReloadListener;
import shims.java.net.minecraft.util.JsonHelper;

public class RecipeDefaultLoader
implements EmiResourceReloadListener,
ResourceManagerReloadListener {
    public static final ResourceLocation ID = new ResourceLocation("emi:recipe_defaults");
    private static final Gson GSON = new Gson();

    public void onResourceManagerReload(ResourceManager manager) {
        RecipeDefaults defaults = new RecipeDefaults();
        try {
            for (Resource resource : manager.getAllResources(new ResourceLocation("emi", "recipe/defaults/defaults.json"))) {
                InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream(resource));
                JsonObject json = JsonHelper.deserialize(GSON, (Reader)reader, JsonObject.class);
                RecipeDefaultLoader.loadDefaults(defaults, json);
            }
        }
        catch (Exception e) {
            EmiLog.error("Error loading recipe default file", e);
        }
        BoM.setDefaults(defaults);
    }

    public static void loadDefaults(RecipeDefaults defaults, JsonObject json) {
        if (JsonHelper.getBoolean(json, "replace", false)) {
            defaults.clear();
        }
        JsonArray disabled = JsonHelper.getArray(json, "disabled", new JsonArray());
        for (Object el : disabled) {
            ResourceLocation id = new ResourceLocation(el.getAsString());
            defaults.remove(id);
        }
        JsonArray added = JsonHelper.getArray(json, "added", new JsonArray());
        if (JsonHelper.hasArray(json, "recipes")) {
            added.addAll(JsonHelper.getArray(json, "recipes"));
        }
        for (Object el : added) {
            ResourceLocation id = new ResourceLocation(el.getAsString());
            defaults.add(id);
        }
        JsonObject resolutions = JsonHelper.getObject(json, "resolutions", new JsonObject());
        for (String key : resolutions.entrySet().stream().map(Map.Entry::getKey).toList()) {
            ResourceLocation id = new ResourceLocation(key);
            if (!JsonHelper.hasArray(resolutions, key)) continue;
            defaults.add(id, JsonHelper.getArray(resolutions, key));
        }
        JsonObject addedTags = JsonHelper.getObject(json, "tags", new JsonObject());
        for (String key : addedTags.entrySet().stream().map(Map.Entry::getKey).toList()) {
            defaults.addTag((JsonElement)new JsonPrimitive(key), addedTags.get(key));
        }
    }

    @Override
    public ResourceLocation getEmiId() {
        return ID;
    }
}

