/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.data.EmiAlias;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moddedmite.emi.api.recipe.MITEEmiRecipeCategories;
import net.minecraft.Block;
import net.minecraft.Item;
import net.minecraft.ResourceLocation;

public class EmiData {
    public static Map<String, EmiRecipeCategoryProperties> categoryPriorities = new HashMap<String, EmiRecipeCategoryProperties>();
    public static List<Supplier<EmiAlias>> aliases = new ArrayList<Supplier<EmiAlias>>();
    public static List<Predicate<EmiRecipe>> recipeFilters = Lists.newArrayList();

    public static void init() {
        EmiData.defaultAliases();
    }

    public static void addAliases(List<EmiIngredient> ingredients, String aliasName) {
        EmiData.addAliases(ingredients, List.of(aliasName));
    }

    public static void addAliases(EmiIngredient ingredient, List<String> aliasName) {
        EmiData.addAliases(List.of(ingredient), aliasName);
    }

    public static void addAliases(EmiIngredient ingredient, String aliasName) {
        EmiData.addAliases(List.of(ingredient), List.of(aliasName));
    }

    public static void addAliases(List<EmiIngredient> ingredients, List<String> aliasName) {
        aliases.add(() -> new EmiAlias(ingredients, aliasName));
    }

    public static void hideRecipe(ResourceLocation id) {
        Predicate<EmiRecipe> predicates = r -> {
            String rid = r.getId() == null ? "null" : r.getId().toString();
            return rid.equals(id.toString());
        };
        recipeFilters.add(predicates);
    }

    public static void setCategoryOrder(int order, EmiRecipeCategory category) {
        EmiRecipeCategoryProperties props = new EmiRecipeCategoryProperties();
        props.order = order;
        categoryPriorities.put(category.getId().toString(), props);
    }

    private static void defaultAliases() {
        List<EmiIngredient> craftingTables = List.of(EmiStack.of(Block.workbench));
        EmiData.addAliases(craftingTables, List.of("alias.emi.crafting_table", "alias.emi.workbench"));
        EmiData.addAliases((EmiIngredient)EmiStack.of(Item.stick), "alias.emi.stick");
        EmiData.addAliases((EmiIngredient)EmiStack.of((Block)Block.tnt), "alias.emi.tnt");
    }

    public static void defaultCategoryOrder() {
        EmiData.setCategoryOrder(-1000, VanillaEmiRecipeCategories.CRAFTING);
        EmiData.setCategoryOrder(100, VanillaEmiRecipeCategories.FUEL);
        EmiData.setCategoryOrder(120, MITEEmiRecipeCategories.FOOD);
    }
}

