/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.emi.emi.config.SidebarSettings;
import dev.emi.emi.config.SidebarSubpanels;
import dev.emi.emi.config.SidebarTheme;
import dev.emi.emi.config.SidebarType;
import java.util.HashSet;
import java.util.List;

public class SidebarPages {
    public final SidebarSettings settings;
    public List<SidebarPage> pages = Lists.newArrayList();

    public SidebarPages(List<SidebarPage> pages, SidebarSettings settings) {
        this.pages.addAll(pages);
        this.settings = settings;
        this.unique();
    }

    public void unique() {
        HashSet types = Sets.newHashSet();
        for (int i = 0; i < this.pages.size(); ++i) {
            if (this.pages.get((int)i).type == SidebarType.NONE || types.contains(this.pages.get((int)i).type)) {
                this.pages.remove(i--);
                continue;
            }
            types.add(this.pages.get((int)i).type);
        }
        if (this.settings.subpanels() != null) {
            List<SidebarSubpanels.Subpanel> subpanels = this.settings.subpanels().subpanels;
            for (int i = 0; i < subpanels.size(); ++i) {
                if (subpanels.get((int)i).type == SidebarType.NONE || types.contains(subpanels.get((int)i).type)) {
                    subpanels.remove(i--);
                    continue;
                }
                types.add(subpanels.get((int)i).type);
            }
        }
    }

    public boolean canShowChess() {
        return this.settings.size().values.get(0) == 8 && this.settings.size().values.get(1) == 8 && this.settings.theme() == SidebarTheme.MODERN;
    }

    public static class SidebarPage {
        public SidebarType type;

        public SidebarPage(SidebarType type) {
            this.type = type;
        }
    }
}

