/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.config;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.config.ConfigEnum;
import dev.emi.emi.platform.EmiAgnos;
import it.unimi.dsi.fastutil.doubles.Double2ObjectFunction;
import shims.java.net.minecraft.text.Text;

public enum FluidUnit implements ConfigEnum
{
    LITERS("liters", (Double2ObjectFunction<Text>)((Double2ObjectFunction)a -> EmiPort.translatable("emi.fluid.amount.liters", EmiRenderHelper.TEXT_FORMAT.format((int)(a / (double)FluidUnit.literDivisor()))))),
    MILLIBUCKETS("millibuckets", (Double2ObjectFunction<Text>)((Double2ObjectFunction)a -> EmiPort.translatable("emi.fluid.amount.millibuckets", EmiRenderHelper.TEXT_FORMAT.format((int)(a / (double)FluidUnit.literDivisor()))))),
    DROPLETS("droplets", (Double2ObjectFunction<Text>)((Double2ObjectFunction)a -> EmiPort.translatable("emi.fluid.amount.droplets", EmiRenderHelper.TEXT_FORMAT.format((int)a))));

    public static final int BUCKET;
    public static final int BOTTLE;
    private final String name;
    private final Text translation;
    private final Double2ObjectFunction<Text> translator;

    private FluidUnit(String name, Double2ObjectFunction<Text> translator) {
        this.name = name;
        this.translation = EmiPort.translatable("emi.unit." + name);
        this.translator = translator;
    }

    public static int literDivisor() {
        if (EmiAgnos.isForge()) {
            return 1;
        }
        return 81;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Text translate(double amount) {
        return (Text)this.translator.apply(amount);
    }

    @Override
    public Text getText() {
        return this.translation;
    }

    static {
        BUCKET = EmiAgnos.isForge() ? 1000 : 81000;
        BOTTLE = EmiAgnos.isForge() ? 250 : 27000;
    }
}

