/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.chess;

import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.chess.ChessPiece;
import dev.emi.emi.chess.PieceColor;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTooltipComponent;
import net.minecraft.FontRenderer;
import shims.java.net.minecraft.text.Text;

class ChessTooltipComponent
implements EmiTooltipComponent {
    private final ChessPiece dragged;
    private final ChessPiece hovered;
    private final Text description;

    public ChessTooltipComponent(ChessPiece dragged, ChessPiece hovered, Text description) {
        this.dragged = dragged;
        this.hovered = hovered;
        this.description = description;
    }

    @Override
    public int getHeight() {
        return 30;
    }

    @Override
    public int getWidth(FontRenderer fontRenderer) {
        return Math.max(fontRenderer.getStringWidth(this.description.asString()), 48);
    }

    @Override
    public void drawTooltip(EmiDrawContext context, EmiTooltipComponent.TooltipRenderData tooltip) {
        context.drawTexture(EmiRenderHelper.PIECES, 0, 14, 100, this.dragged.type().u, this.dragged.color() == PieceColor.BLACK ? 0.0f : 16.0f, 16, 16);
        context.drawTexture(EmiRenderHelper.PIECES, 32, 14, 100, this.hovered.type().u, this.hovered.color() == PieceColor.BLACK ? 0.0f : 16.0f, 16, 16);
    }

    @Override
    public void drawTooltipText(EmiTooltipComponent.TextRenderData text) {
        text.draw(this.description, 0, 4, 0xFFFFFF, true);
        text.draw("->", 18, 19, 0xFFFFFF, true);
    }
}

