/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.chess;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.chess.ChessMove;
import dev.emi.emi.chess.ChessPiece;
import dev.emi.emi.chess.ChessTooltipComponent;
import dev.emi.emi.chess.EmiChess;
import dev.emi.emi.chess.PieceColor;
import dev.emi.emi.chess.PieceType;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.EntityPlayer;
import net.minecraft.Minecraft;
import net.minecraft.NBTTagCompound;
import net.minecraft.ResourceLocation;
import shims.java.com.mojang.blaze3d.systems.RenderSystem;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.text.Text;

class ChessEmiStack
extends EmiStack {
    public final int position;

    public ChessEmiStack(int position) {
        this.position = position;
    }

    @Override
    public void render(DrawContext raw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        ChessPiece piece = EmiChess.getBoard().get(this.position);
        RenderSystem.enableDepthTest();
        EmiChess chess = EmiChess.get();
        if (chess.pendingPromotion != -1) {
            int dir;
            PieceType type = null;
            int n = dir = chess.pendingPromotion > 31 ? -8 : 8;
            if (this.position == chess.pendingPromotion) {
                type = PieceType.QUEEN;
            } else if (this.position == chess.pendingPromotion + dir) {
                type = PieceType.KNIGHT;
            } else if (this.position == chess.pendingPromotion + dir * 2) {
                type = PieceType.ROOK;
            } else if (this.position == chess.pendingPromotion + dir * 3) {
                type = PieceType.BISHOP;
            }
            if (type != null) {
                context.push();
                context.matrices().translate(0.0, 0.0, 10.0);
                context.fill(x - 1, y - 1, 18, 18, 0x55000000);
                context.matrices().translate(0.0, 0.0, 90.0);
                context.drawTexture(EmiRenderHelper.PIECES, x, y, 100, type.u, chess.pendingPromotion > 31 ? 0.0f : 16.0f, 16, 16, 256, 256);
                context.pop();
                return;
            }
        }
        context.push();
        context.matrices().translate(0.0, 0.0, 10.0);
        if (chess.isTarget(this.position)) {
            context.fill(x - 1, y - 1, 18, 18, 0x5555FF00);
        }
        boolean dragging = !EmiScreenManager.draggedStack.isEmpty();
        ChessMove move = chess.board.lastMove;
        if (!(dragging || move == null || move.start() != this.position && move.end() != this.position)) {
            context.fill(x - 1, y - 1, 18, 18, 0x55AAAA00);
        }
        if (!dragging && piece != null && piece.type() == PieceType.KING && chess.board.isChecked(piece.color())) {
            context.fill(x - 1, y - 1, 18, 18, 0x55FF0000);
        }
        context.pop();
        if (piece != null) {
            context.push();
            context.matrices().translate(0.0, 0.0, 100.0);
            context.resetColor();
            context.drawTexture(EmiRenderHelper.PIECES, x, y, 100, piece.type().u, piece.color() == PieceColor.BLACK ? 0.0f : 16.0f, 16, 16, 256, 256);
            context.pop();
        }
    }

    @Override
    public EmiStack copy() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return EmiChess.get().board.get(this.position) == null;
    }

    @Override
    public NBTTagCompound getNbt() {
        return null;
    }

    @Override
    public Object getKey() {
        return this.position;
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("emi:/chess/" + this.position);
    }

    @Override
    public List<Text> getTooltipText() {
        return List.of();
    }

    @Override
    public List<TooltipComponent> getTooltip() {
        ChessPiece piece = EmiChess.getBoard().get(this.position);
        if (piece != null) {
            ArrayList list = Lists.newArrayList();
            list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("emi.chess.piece." + piece.color().toString().toLowerCase() + "_" + piece.type().toString().toLowerCase()))));
            Minecraft client = Minecraft.getMinecraft();
            if (!EmiChess.get().started) {
                if (piece.type() == PieceType.KING) {
                    EntityPlayer player;
                    list.add(new ChessTooltipComponent(ChessPiece.of(PieceType.PAWN, PieceColor.BLACK), ChessPiece.of(PieceType.KING, PieceColor.BLACK), EmiPort.translatable("emi.chess.tooltip.invite")));
                    if (EmiChess.get().pending != null && (player = client.theWorld.getPlayerEntityByName(EmiChess.get().pending)) != null) {
                        list.add(new ChessTooltipComponent(ChessPiece.of(PieceType.KING, PieceColor.WHITE), ChessPiece.of(PieceType.KING, PieceColor.BLACK), EmiPort.translatable("emi.chess.tooltip.accept", player.getCommandSenderName())));
                        list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("emi.chess.tooltip.decline", player.getCommandSenderName()))));
                    }
                }
            } else if (piece.type() == PieceType.KING && piece.color() == PieceColor.WHITE) {
                list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("emi.chess.tooltip.restart"))));
            }
            return list;
        }
        return List.of();
    }

    @Override
    public Text getName() {
        return EmiPort.literal("Chess Piece");
    }
}

