/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetTooltipHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;

public class TextureWidget
extends Widget
implements WidgetTooltipHolder<TextureWidget> {
    protected final ResourceLocation texture;
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final int u;
    protected final int v;
    protected final int regionWidth;
    protected final int regionHeight;
    protected final int textureWidth;
    protected final int textureHeight;
    private BiFunction<Integer, Integer, List<TooltipComponent>> tooltipSupplier = (mouseX, mouseY) -> Collections.emptyList();

    public TextureWidget(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        this.texture = texture;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public TextureWidget(ResourceLocation texture, int x, int y, int width, int height, int u, int v) {
        this(texture, x, y, width, height, u, v, width, height, 256, 256);
    }

    @Override
    public TextureWidget tooltip(BiFunction<Integer, Integer, List<TooltipComponent>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    @Override
    public List<TooltipComponent> getTooltip(int mouseX, int mouseY) {
        return this.tooltipSupplier.apply(mouseX, mouseY);
    }

    @Override
    public void render(DrawContext draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        context.resetColor();
        context.drawTexture(this.texture, this.x, this.y, this.width, this.height, this.u, this.v, this.regionWidth, this.regionHeight, this.textureWidth, this.textureHeight);
    }
}

