/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.Minecraft;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.text.OrderedText;

public class TextWidget
extends Widget {
    private static final Minecraft CLIENT = Minecraft.getMinecraft();
    protected final OrderedText text;
    protected final int x;
    protected final int y;
    protected final int color;
    protected final boolean shadow;
    protected Alignment horizontalAlignment = Alignment.START;
    protected Alignment verticalAlignment = Alignment.START;

    public TextWidget(OrderedText text, int x, int y, int color, boolean shadow) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.color = color;
        this.shadow = shadow;
    }

    public TextWidget horizontalAlign(Alignment alignment) {
        this.horizontalAlignment = alignment;
        return this;
    }

    public TextWidget verticalAlign(Alignment alignment) {
        this.verticalAlignment = alignment;
        return this;
    }

    @Override
    public Bounds getBounds() {
        int width = TextWidget.CLIENT.fontRenderer.getStringWidth(this.text.asString());
        int xOff = this.horizontalAlignment.offset(width);
        int yOff = this.verticalAlignment.offset(TextWidget.CLIENT.fontRenderer.FONT_HEIGHT);
        return new Bounds(this.x + xOff, this.y + yOff, width, TextWidget.CLIENT.fontRenderer.FONT_HEIGHT);
    }

    @Override
    public void render(DrawContext draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        context.push();
        int xOff = this.horizontalAlignment.offset(TextWidget.CLIENT.fontRenderer.getStringWidth(this.text.asString()));
        int yOff = this.verticalAlignment.offset(TextWidget.CLIENT.fontRenderer.FONT_HEIGHT);
        context.matrices().translate(xOff, yOff, 300.0);
        if (this.shadow) {
            context.drawTextWithShadow(this.text, this.x, this.y, this.color);
        } else {
            context.drawText(this.text, this.x, this.y, this.color);
        }
        context.pop();
    }

    public static enum Alignment {
        START,
        CENTER,
        END;


        public int offset(int length) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case START -> 0;
                case CENTER -> -(length / 2);
                case END -> -length;
            };
        }
    }
}

