/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiFillAction;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.input.EmiInput;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.widget.RecipeButtonWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.GuiContainer;
import org.jetbrains.annotations.ApiStatus;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;

public class RecipeFillButtonWidget
extends RecipeButtonWidget {
    private boolean canFill;
    private List<TooltipComponent> tooltip;

    @ApiStatus.Internal
    public RecipeFillButtonWidget(int x, int y, EmiRecipe recipe) {
        super(x, y, 24, 0, recipe);
        GuiContainer hs = EmiApi.getHandledScreen();
        EmiRecipeHandler handler = EmiRecipeFiller.getFirstValidHandler(recipe, hs);
        this.tooltip = List.of(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("emi.inapplicable"))));
        if (handler == null) {
            this.canFill = false;
        } else {
            try {
                EmiPlayerInventory inv = handler.getInventory(hs);
                boolean applicable = handler.supportsRecipe(recipe);
                EmiCraftContext context = new EmiCraftContext(hs, inv, EmiCraftContext.Type.FILL_BUTTON);
                boolean bl = this.canFill = applicable && handler.canCraft(recipe, context);
                if (applicable) {
                    this.tooltip = handler.getTooltip(recipe, context);
                }
            }
            catch (Exception e) {
                this.canFill = false;
                this.tooltip = List.of(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("emi.error.recipe.initialize"))));
            }
        }
    }

    @Override
    public int getTextureOffset(int mouseX, int mouseY) {
        if (!this.canFill) {
            return 24;
        }
        return super.getTextureOffset(mouseX, mouseY);
    }

    @Override
    public List<TooltipComponent> getTooltip(int mouseX, int mouseY) {
        ArrayList list = Lists.newArrayList();
        if (this.canFill) {
            list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("tooltip.emi.fill_recipe"))));
        }
        list.addAll(this.tooltip);
        return list;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        GuiContainer hs;
        if (this.canFill && (hs = EmiApi.getHandledScreen()) != null && EmiRecipeFiller.performFill(this.recipe, hs, EmiFillAction.FILL, EmiInput.isShiftDown() ? Integer.MAX_VALUE : 1)) {
            this.playButtonSound();
            return true;
        }
        return false;
    }
}

