/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetTooltipHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;

public class DrawableWidget
extends Widget
implements WidgetTooltipHolder<DrawableWidget> {
    protected final DrawableWidgetConsumer consumer;
    protected final Bounds bounds;
    protected final int x;
    protected final int y;
    protected BiFunction<Integer, Integer, List<TooltipComponent>> tooltipSupplier = (mouseX, mouseY) -> Collections.emptyList();

    public DrawableWidget(int x, int y, int w, int h, DrawableWidgetConsumer consumer) {
        this.x = x;
        this.y = y;
        this.bounds = new Bounds(x, y, w, h);
        this.consumer = consumer;
    }

    @Override
    public DrawableWidget tooltip(BiFunction<Integer, Integer, List<TooltipComponent>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public List<TooltipComponent> getTooltip(int mouseX, int mouseY) {
        return this.tooltipSupplier.apply(mouseX, mouseY);
    }

    @Override
    public void render(DrawContext draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        context.push();
        context.matrices().translate(this.x, this.y, 0.0);
        this.consumer.render(context.raw(), mouseX, mouseY, delta);
        context.pop();
    }

    public static interface DrawableWidgetConsumer {
        public void render(DrawContext var1, int var2, int var3, float var4);
    }
}

