/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.client.gui.DrawContext;

public class CustomAnimatedTextureWidget
extends TextureWidget {
    protected final int time;
    protected final int frameCount;
    protected int internalCount = 0;
    protected int oldCount;

    public CustomAnimatedTextureWidget(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, int time, int frameCount) {
        super(texture, x, y, width, height, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
        this.time = time;
        this.frameCount = frameCount;
    }

    public CustomAnimatedTextureWidget(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int time, int frameCount) {
        this(texture, x, y, width, height, u, v, width, height, 256, 256, time, frameCount);
    }

    @Override
    public void render(DrawContext draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        int totalTime = (int)Minecraft.getMinecraft().theWorld.getTotalWorldTime() % this.time;
        if (totalTime % this.time == 0 & totalTime != this.oldCount || this.time == 1) {
            ++this.internalCount;
            if (this.internalCount >= this.frameCount) {
                this.internalCount = 0;
            }
        }
        context.drawTexture(this.texture, this.x, this.y, this.width, this.height, this.u, this.v + this.regionHeight * this.internalCount, this.regionWidth, this.regionHeight, this.textureWidth, this.textureHeight);
        this.oldCount = totalTime;
    }
}

