/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.function.BooleanSupplier;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import org.lwjgl.opengl.GL11;
import shims.java.net.minecraft.client.gui.DrawContext;

public class ButtonWidget
extends Widget {
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final int u;
    protected final int v;
    protected final BooleanSupplier isActive;
    protected final ClickAction action;
    protected final ResourceLocation texture;

    public ButtonWidget(int x, int y, int width, int height, int u, int v, BooleanSupplier isActive, ClickAction action) {
        this(x, y, width, height, u, v, EmiRenderHelper.BUTTONS, isActive, action);
    }

    public ButtonWidget(int x, int y, int width, int height, int u, int v, ResourceLocation texture, BooleanSupplier isActive, ClickAction action) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.texture = texture;
        this.isActive = isActive;
        this.action = action;
    }

    @Override
    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    @Override
    public void render(DrawContext draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        int v = this.v;
        boolean active = this.isActive.getAsBoolean();
        if (!active) {
            v += this.height * 2;
        } else if (this.getBounds().contains(mouseX, mouseY)) {
            v += this.height;
        }
        GL11.glEnable((int)2929);
        context.drawTexture(this.texture, this.x, this.y, this.u, v, this.width, this.height);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.action.click(mouseX, mouseY, button);
        Minecraft.getMinecraft().sndManager.playSoundFX("random.click", 1.0f, 1.0f);
        return true;
    }

    public static interface ClickAction {
        public void click(double var1, double var3, int var5);
    }
}

