/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.runtime.EmiLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.NBTTagCompound;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.nbt.StringNbtReader;
import shims.java.net.minecraft.util.JsonHelper;

public interface EmiStackSerializer<T extends EmiStack>
extends EmiIngredientSerializer<T> {
    public static final Pattern STACK_REGEX = Pattern.compile("^([\\w_\\-./]+):([\\w_\\-.]+):([\\w_\\-./]+)(\\{.*\\})?$");

    public EmiStack create(ResourceLocation var1, NBTTagCompound var2, long var3);

    @Override
    default public EmiIngredient deserialize(JsonElement element) {
        ResourceLocation id = null;
        String nbt = null;
        long amount = 1L;
        float chance = 1.0f;
        EmiStack remainder = EmiStack.EMPTY;
        if (JsonHelper.isString(element)) {
            String s = element.getAsString();
            Matcher m = STACK_REGEX.matcher(s);
            if (m.matches()) {
                id = new ResourceLocation(m.group(2), m.group(3));
                nbt = m.group(4);
            }
        } else if (element.isJsonObject()) {
            EmiIngredient ing;
            JsonObject json = element.getAsJsonObject();
            id = new ResourceLocation(JsonHelper.getString(json, "id"));
            nbt = JsonHelper.getString(json, "nbt", null);
            amount = JsonHelper.getLong(json, "amount", 1L);
            chance = JsonHelper.getFloat(json, "chance", 1.0f);
            if (JsonHelper.hasElement(json, "remainder") && (ing = EmiIngredientSerializer.getDeserialized(json.get("remainder"))) instanceof EmiStack) {
                EmiStack stack;
                remainder = stack = (EmiStack)ing;
            }
        }
        if (id != null) {
            try {
                NBTTagCompound nbtComp = null;
                if (nbt != null) {
                    nbtComp = StringNbtReader.parse(nbt);
                }
                EmiStack stack = this.create(id, nbtComp, amount);
                if (chance != 1.0f) {
                    stack.setChance(chance);
                }
                if (!remainder.isEmpty()) {
                    stack.setRemainder(remainder);
                }
                return stack;
            }
            catch (Exception e) {
                EmiLog.error("Error parsing NBT in deserialized stack", e);
                return EmiStack.EMPTY;
            }
        }
        return EmiStack.EMPTY;
    }

    @Override
    default public JsonElement serialize(T stack) {
        String nbt = null;
        if (((EmiStack)stack).hasNbt()) {
            nbt = nbt + StringNbtReader.encode(((EmiStack)stack).getNbt());
        }
        if (((EmiStack)stack).getAmount() == 1L && ((EmiStack)stack).getChance() == 1.0f && ((EmiStack)stack).getRemainder().isEmpty()) {
            String s = this.getType() + ":" + ((EmiStack)stack).getId();
            if (nbt != null) {
                s = s + nbt;
            }
            return new JsonPrimitive(s);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        json.addProperty("id", ((EmiStack)stack).getId().toString());
        if (nbt != null) {
            json.addProperty("nbt", nbt);
        }
        if (((EmiStack)stack).getAmount() != 1L) {
            json.addProperty("amount", (Number)((EmiStack)stack).getAmount());
        }
        if (((EmiStack)stack).getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(((EmiStack)stack).getChance()));
        }
        if (!((EmiStack)stack).getRemainder().isEmpty()) {
            JsonElement remainderElement;
            EmiStack remainder = ((EmiStack)stack).getRemainder();
            if (!remainder.getRemainder().isEmpty()) {
                remainder = remainder.copy().setRemainder(EmiStack.EMPTY);
            }
            if (remainder.getRemainder().isEmpty() && (remainderElement = EmiIngredientSerializer.getSerialized(remainder)) != null) {
                json.add("remainder", remainderElement);
            }
        }
        return json;
    }
}

