/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import dev.emi.emi.screen.tooltip.TagTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.tag.TagKey;
import shims.java.net.minecraft.tag.WildcardItemTag;
import shims.java.net.minecraft.util.Formatting;

@ApiStatus.Internal
public class TagEmiIngredient
implements EmiIngredient {
    private final ResourceLocation id;
    private List<EmiStack> stacks;
    public final TagKey<?> key;
    private long amount;
    private float chance = 1.0f;

    @ApiStatus.Internal
    public TagEmiIngredient(TagKey<?> key, long amount) {
        this(key, TagEmiIngredient.fromKey(key), amount);
    }

    private static List<EmiStack> fromKey(TagKey<?> key) {
        if (key instanceof WildcardItemTag) {
            return key.get().stream().map(EmiStack::of).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Unsupported tag registry " + key);
    }

    @ApiStatus.Internal
    public TagEmiIngredient(TagKey<?> key, List<EmiStack> stacks, long amount) {
        this.id = key.id();
        this.key = key;
        this.stacks = stacks;
        this.amount = amount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TagEmiIngredient)) return false;
        TagEmiIngredient tag = (TagEmiIngredient)obj;
        if (!tag.key.equals(this.key)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public EmiIngredient copy() {
        TagEmiIngredient stack = new TagEmiIngredient(this.key, this.amount);
        stack.setChance(this.chance);
        return stack;
    }

    @Override
    public List<EmiStack> getEmiStacks() {
        return this.stacks;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public EmiIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public EmiIngredient setChance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public void render(DrawContext draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        Minecraft client = Minecraft.getMinecraft();
        if ((flags & 1) != 0 && !EmiTags.hasCustomModel(this.key) && this.stacks.size() > 0) {
            this.stacks.get(0).render(context.raw(), x, y, delta, -3);
        }
        if ((flags & 2) != 0) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, EmiPort.literal((String)count));
        }
        if ((flags & 4) != 0) {
            EmiRender.renderTagIcon(this, context.raw(), x, y);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public List<TooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(TooltipComponent.of(EmiPort.ordered(EmiTags.getTagName(this.key))));
        if (EmiUtil.showAdvancedTooltips()) {
            list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.literal("#" + this.id, Formatting.DARK_GRAY))));
        }
        if (EmiConfig.appendModId) {
            String mod = EmiUtil.getModName(this.id.getResourceDomain());
            list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.literal(mod, Formatting.BLUE, Formatting.ITALIC))));
        }
        list.add(new TagTooltipComponent(this.stacks));
        for (EmiStack stack : this.stacks) {
            if (stack.getRemainder().isEmpty()) continue;
            list.add(new RemainderTooltipComponent(this));
            break;
        }
        return list;
    }
}

