/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.Prototype;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.StackBatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import moddedmite.emi.util.ModIdentifier;
import net.minecraft.EntityPlayer;
import net.minecraft.ItemBlock;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import net.minecraft.NBTTagCompound;
import net.minecraft.RenderHelper;
import net.minecraft.ResourceLocation;
import net.minecraft.Slot;
import net.xiaoyu233.fml.FishModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11;
import shims.java.com.unascribed.retroemi.ItemStacks;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.render.VertexConsumerProvider;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Formatting;
import shims.java.net.minecraft.util.NumericIdentifier;

@ApiStatus.Internal
public class ItemEmiStack
extends EmiStack
implements StackBatcher.Batchable {
    private static final Minecraft client = Minecraft.getMinecraft();
    private final ItemStack stack;
    private boolean unbatchable;

    public ItemEmiStack(ItemStack stack) {
        this(stack, stack.stackSize);
    }

    public ItemEmiStack(ItemStack stack, long amount) {
        stack = stack.copy();
        stack.stackSize = (int)amount;
        this.stack = stack;
        this.amount = amount;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.stack == null) {
            return null;
        }
        this.stack.stackSize = (int)this.amount;
        return this.stack;
    }

    @Override
    public EmiStack copy() {
        ItemEmiStack e = new ItemEmiStack(this.stack.copy(), this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0L || ItemStacks.isEmpty(this.stack);
    }

    @Override
    public NBTTagCompound getNbt() {
        return this.stack.getTagCompound();
    }

    @Override
    public Object getKey() {
        return Prototype.of(this.stack);
    }

    @Override
    public ResourceLocation getId() {
        return new NumericIdentifier(this.stack.itemID);
    }

    @Override
    public int hashCode() {
        if (this.stack == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.stack.itemID;
        result = 31 * result + (this.stack.getItem().getHasSubtypes() ? this.stack.getItemSubtype() : 0);
        return result;
    }

    @Override
    public void render(DrawContext draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        ItemStack stack = this.getItemStack();
        if ((flags & 1) != 0) {
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2929);
            RenderHelper.enableGUIStandardItemLighting();
            if (stack.getItem() instanceof ItemBlock && stack.getItemSubtype() == Short.MAX_VALUE) {
                stack.setItemSubtype(0);
            }
            draw.drawItem(stack, x, y);
            draw.drawItemInSlot(Minecraft.getMinecraft().fontRenderer, stack, x, y);
        }
        if ((flags & 2) != 0) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, EmiPort.literal((String)count));
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public boolean isSideLit() {
        return RetroEMI.isSideLit(this.getItemStack());
    }

    @Override
    public boolean isUnbatchable() {
        ItemStack stack = this.getItemStack();
        return this.unbatchable || stack.isItemEnchanted() || stack.isItemDamaged() || !EmiAgnos.canBatch(stack);
    }

    @Override
    public void setUnbatchable() {
        this.unbatchable = true;
    }

    @Override
    public void renderForBatch(VertexConsumerProvider vcp, DrawContext draw, int x, int y, int z, float delta) {
    }

    @Override
    public List<Text> getTooltipText() {
        return this.getItemStack().getTooltip((EntityPlayer)Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().gameSettings.advancedItemTooltips, (Slot)null).stream().map(Text::literal).collect(Collectors.toList());
    }

    @Override
    public List<TooltipComponent> getTooltip() {
        ItemStack stack = this.getItemStack();
        ArrayList list = Lists.newArrayList();
        if (!this.isEmpty()) {
            list.addAll(EmiAgnos.getItemTooltip(stack));
            if (!FishModLoader.hasMod((String)"better_tips") && (EmiConfig.appendModId || EmiConfig.appendItemModId)) {
                list.add(TooltipComponent.of(Text.literal(ModIdentifier.getMod(stack)).formatted(Formatting.BLUE, Formatting.ITALIC)));
            }
            list.addAll(super.getTooltip());
        }
        return list;
    }

    @Override
    public Text getName() {
        if (this.isEmpty()) {
            return EmiPort.literal("");
        }
        return Text.literal(this.getItemStack().getDisplayName());
    }

    static class ItemEntry {
        ItemEntry() {
        }
    }
}

