/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import dev.emi.emi.Prototype;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmptyEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.Block;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.NBTTagCompound;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import shims.java.com.unascribed.retroemi.ItemStacks;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.item.DyeItem;
import shims.java.net.minecraft.text.Text;

public abstract class EmiStack
implements EmiIngredient {
    public static final EmiStack EMPTY = new EmptyEmiStack();
    private EmiStack remainder = EMPTY;
    protected Comparison comparison = Comparison.DEFAULT_COMPARISON;
    protected long amount = 1L;
    protected float chance = 1.0f;

    @Override
    public List<EmiStack> getEmiStacks() {
        return Collections.singletonList(this);
    }

    public EmiStack getRemainder() {
        return this.remainder;
    }

    public EmiStack setRemainder(EmiStack stack) {
        if (stack == this) {
            stack = stack.copy();
        }
        this.remainder = stack;
        return this;
    }

    public EmiStack comparison(Function<Comparison, Comparison> comparison) {
        this.comparison = comparison.apply(this.comparison);
        return this;
    }

    public EmiStack comparison(Comparison comparison) {
        this.comparison = comparison;
        return this;
    }

    @Override
    public abstract EmiStack copy();

    @Override
    public abstract boolean isEmpty();

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public EmiStack setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public EmiStack setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public abstract NBTTagCompound getNbt();

    public boolean hasNbt() {
        return this.getNbt() != null;
    }

    public abstract Object getKey();

    @Nullable
    public <T> T getKeyOfType(Class<T> clazz) {
        Object o = this.getKey();
        if (clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }

    public abstract ResourceLocation getId();

    public ItemStack getItemStack() {
        return ItemStacks.EMPTY;
    }

    public boolean isEqual(EmiStack stack) {
        Comparison b;
        Prototype p;
        if (stack.getClass() != this.getClass()) {
            return false;
        }
        Object ka = this.getKey();
        Object kb = stack.getKey();
        if (ka instanceof Prototype) {
            p = (Prototype)ka;
            ka = p.getItem();
        }
        if (kb instanceof Prototype) {
            p = (Prototype)kb;
            kb = p.getItem();
        }
        if (!Objects.equals(ka, kb)) {
            return false;
        }
        Comparison a = this.comparison == Comparison.DEFAULT_COMPARISON ? EmiComparisonDefaults.get(this.getKey()) : this.comparison;
        Comparison comparison = b = stack.comparison == Comparison.DEFAULT_COMPARISON ? EmiComparisonDefaults.get(stack.getKey()) : stack.comparison;
        if (a == b) {
            return a.compare(this, stack);
        }
        return a.compare(this, stack) && b.compare(this, stack);
    }

    public boolean isEqual(EmiStack stack, Comparison comparison) {
        Prototype p;
        if (stack.getClass() != this.getClass()) {
            return false;
        }
        Object ka = this.getKey();
        Object kb = stack.getKey();
        if (ka instanceof Prototype) {
            p = (Prototype)ka;
            ka = p.getItem();
        }
        if (kb instanceof Prototype) {
            p = (Prototype)kb;
            kb = p.getItem();
        }
        if (!Objects.equals(ka, kb)) {
            return false;
        }
        return comparison.compare(this, stack);
    }

    public abstract List<Text> getTooltipText();

    @Override
    public List<TooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        if (!this.getRemainder().isEmpty()) {
            list.add(new RemainderTooltipComponent(this));
        }
        return list;
    }

    public abstract Text getName();

    public boolean equals(Object obj) {
        if (obj instanceof EmiStack) {
            EmiStack stack = (EmiStack)obj;
            return this.isEqual(stack);
        }
        if (obj instanceof EmiIngredient) {
            EmiIngredient stack = (EmiIngredient)obj;
            return EmiIngredient.areEqual(this, stack);
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (this.getKey() == null ? 0 : this.getKey().hashCode());
    }

    public String toString() {
        String s = "" + this.getKey();
        NBTTagCompound nbt = this.getNbt();
        if (nbt != null) {
            s = s + nbt;
        }
        return s + " x" + this.getAmount();
    }

    public static EmiStack of(Prototype proto) {
        return new ItemEmiStack(proto.toStack());
    }

    public static EmiStack of(ItemStack stack) {
        if (ItemStacks.isEmpty(stack)) {
            return EMPTY;
        }
        return new ItemEmiStack(stack);
    }

    public static EmiStack of(ItemStack stack, long amount) {
        if (ItemStacks.isEmpty(stack)) {
            return EMPTY;
        }
        return new ItemEmiStack(stack, amount);
    }

    public static EmiStack of(Item item) {
        if (item == null) {
            return EMPTY;
        }
        return EmiStack.of(new ItemStack(item), 1L);
    }

    public static EmiStack of(Item item, long amount) {
        if (item == null) {
            return EMPTY;
        }
        return EmiStack.of(new ItemStack(item), amount);
    }

    public static EmiStack of(DyeItem i) {
        return EmiStack.of(i.toStack());
    }

    public static EmiStack of(Block block) {
        if (block == null) {
            return EMPTY;
        }
        return EmiStack.of(new ItemStack(block), 1L);
    }

    public static EmiStack of(Block block, long amount) {
        if (block == null) {
            return EMPTY;
        }
        return EmiStack.of(new ItemStack(block), amount);
    }

    static abstract class Entry<T> {
        Entry() {
        }
    }
}

