/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.Prototype;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.registry.EmiTags;
import java.util.List;
import java.util.stream.Collectors;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.tag.TagKey;

public interface EmiIngredient
extends EmiRenderable {
    public static final int RENDER_ICON = 1;
    public static final int RENDER_AMOUNT = 2;
    public static final int RENDER_INGREDIENT = 4;
    public static final int RENDER_REMAINDER = 8;

    public List<EmiStack> getEmiStacks();

    default public boolean isEmpty() {
        for (EmiStack stack : this.getEmiStacks()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public EmiIngredient copy();

    public long getAmount();

    public EmiIngredient setAmount(long var1);

    public float getChance();

    public EmiIngredient setChance(float var1);

    @Override
    default public void render(DrawContext draw, int x, int y, float delta) {
        this.render(draw, x, y, delta, -1);
    }

    public void render(DrawContext var1, int var2, int var3, float var4, int var5);

    public List<TooltipComponent> getTooltip();

    public static boolean areEqual(EmiIngredient a, EmiIngredient b) {
        List<EmiStack> as = a.getEmiStacks();
        List<EmiStack> bs = b.getEmiStacks();
        if (as.size() != bs.size()) {
            return false;
        }
        for (int i = 0; i < as.size(); ++i) {
            if (as.get(i).isEqual(bs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> EmiIngredient of(TagKey<T> key) {
        return EmiIngredient.of(key, 1L);
    }

    public static <T> EmiIngredient of(TagKey<T> key, long amount) {
        List<EmiStack> stacks = EmiTags.getValues(key);
        if (stacks.isEmpty()) {
            return EmiStack.EMPTY;
        }
        if (stacks.size() == 1) {
            return stacks.get(0);
        }
        return new TagEmiIngredient(key, stacks, amount);
    }

    public static EmiIngredient of(List<? extends EmiIngredient> list) {
        return EmiIngredient.of(list, 1L);
    }

    public static EmiIngredient of(List<? extends EmiIngredient> list, long amount) {
        if (list.size() == 0) {
            return EmiStack.EMPTY;
        }
        if (list.size() == 1 && amount <= 64L) {
            return list.get(0);
        }
        if (list.size() == 1) {
            return new ListEmiIngredient(list, amount - 64L);
        }
        long internalAmount = list.get(0).getAmount();
        for (EmiIngredient i2 : list) {
            if (i2.getAmount() == internalAmount) continue;
            internalAmount = 1L;
        }
        if (internalAmount > 1L) {
            amount = internalAmount;
            list = list.stream().map(st -> st.copy().setAmount(1L)).collect(Collectors.toList());
        }
        Class<Prototype> tagType = null;
        for (EmiIngredient i3 : list) {
            for (EmiStack s : i3.getEmiStacks()) {
                if (s.isEmpty()) continue;
                Class<Prototype> tt = null;
                if (s.getKey() instanceof Prototype) {
                    tt = Prototype.class;
                }
                if (tt == null) {
                    return new ListEmiIngredient(list, amount);
                }
                tagType = tt;
            }
        }
        return EmiTags.getIngredient(tagType, list.stream().flatMap(i -> i.getEmiStacks().stream()).collect(Collectors.toList()), amount);
    }
}

