/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.ItemStack;
import net.minecraft.NBTTagCompound;

public class Comparison {
    public static final Comparison DEFAULT_COMPARISON = Comparison.of((a, b) -> Comparison.getEffectiveMeta(a.getItemStack()) == Comparison.getEffectiveMeta(b.getItemStack()));
    private static final Comparison COMPARE_NBT = Comparison.of((a, b) -> {
        if (!DEFAULT_COMPARISON.compare(a, b)) {
            return false;
        }
        NBTTagCompound an = a.getNbt();
        NBTTagCompound bn = b.getNbt();
        if (an == null || bn == null) {
            return an == bn;
        }
        return an.equals((Object)bn);
    });
    public static final Comparison LAX = Comparison.of((a, b) -> true);
    private final Predicate predicate;

    private static int getEffectiveMeta(ItemStack is) {
        if (is == null) {
            return 0;
        }
        if (!is.getItem().getHasSubtypes() || is.isItemStackDamageable()) {
            return 0;
        }
        return is.getItemSubtype();
    }

    private Comparison(Predicate comparator) {
        this.predicate = comparator;
    }

    public static Comparison of(Predicate comparator) {
        return new Comparison(comparator);
    }

    public static Comparison compareNbt() {
        return COMPARE_NBT;
    }

    public static Comparison compareComponents() {
        return COMPARE_NBT;
    }

    public boolean compare(EmiStack a, EmiStack b) {
        return this.predicate.test(a, b);
    }

    public static interface Predicate {
        public boolean test(EmiStack var1, EmiStack var2);
    }

    static class Builder {
        Builder() {
        }
    }
}

