/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.render;

import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.screen.tooltip.IngredientTooltipComponent;
import dev.emi.emi.screen.tooltip.RecipeCostTooltipComponent;
import dev.emi.emi.screen.tooltip.RecipeTooltipComponent;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import java.util.List;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Formatting;

public class EmiTooltipComponents {
    public static TooltipComponent getRecipeTooltipComponent(EmiRecipe recipe) {
        return new RecipeTooltipComponent(recipe);
    }

    public static TooltipComponent getRemainderTooltipComponent(EmiIngredient ingredient) {
        return new RemainderTooltipComponent(ingredient);
    }

    public static TooltipComponent getRecipeCostTooltipComponent(EmiRecipe recipe) {
        return new RecipeCostTooltipComponent(recipe);
    }

    public static TooltipComponent getIngredientTooltipComponent(List<? extends EmiIngredient> stacks) {
        return new IngredientTooltipComponent(stacks);
    }

    public static TooltipComponent getAmount(EmiIngredient ingredient) {
        return EmiTooltipComponents.of(EmiRenderHelper.getAmountText(ingredient, ingredient.getAmount()).copy().formatted(Formatting.GRAY));
    }

    public static TooltipComponent of(Text text) {
        return TooltipComponent.of(text.asOrderedText());
    }
}

