/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.recipe.handler;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.widget.Widget;
import java.util.Collections;
import java.util.List;
import net.minecraft.Container;
import net.minecraft.GuiContainer;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.text.Text;

public interface EmiRecipeHandler<T extends Container> {
    public static final Text NOT_ENOUGH_INGREDIENTS = EmiPort.translatable("emi.not_enough_ingredients");

    public EmiPlayerInventory getInventory(GuiContainer var1);

    public boolean supportsRecipe(EmiRecipe var1);

    default public boolean alwaysDisplaySupport(EmiRecipe recipe) {
        return true;
    }

    public boolean canCraft(EmiRecipe var1, EmiCraftContext<T> var2);

    public boolean craft(EmiRecipe var1, EmiCraftContext<T> var2);

    default public List<TooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<T> context) {
        if (this.canCraft(recipe, context)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(TooltipComponent.of(EmiPort.ordered(NOT_ENOUGH_INGREDIENTS)));
    }

    default public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, DrawContext draw) {
    }
}

