/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.recipe;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Formatting;

public class EmiRecipeCategory
implements EmiRenderable {
    public ResourceLocation id;
    public EmiRenderable icon;
    public EmiRenderable simplified;
    @ApiStatus.Experimental
    public Comparator<EmiRecipe> sorter;

    public EmiRecipeCategory(ResourceLocation id, EmiRenderable icon) {
        this(id, icon, icon);
    }

    public EmiRecipeCategory(ResourceLocation id, EmiRenderable icon, EmiRenderable simplified) {
        this(id, icon, simplified, EmiRecipeSorting.none());
    }

    @ApiStatus.Experimental
    public EmiRecipeCategory(ResourceLocation id, EmiRenderable icon, EmiRenderable simplified, Comparator<EmiRecipe> sorter) {
        this.id = id;
        this.icon = icon;
        this.simplified = simplified;
        this.sorter = sorter;
    }

    public Text getName() {
        return EmiPort.translatable(EmiUtil.translateId("emi.category.", this.getId()));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void render(DrawContext draw, int x, int y, float delta) {
        EmiRecipeCategoryProperties.getIcon(this).render(draw, x, y, delta);
    }

    public void renderSimplified(DrawContext draw, int x, int y, float delta) {
        EmiRecipeCategoryProperties.getSimplifiedIcon(this).render(draw, x, y, delta);
    }

    public List<TooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(TooltipComponent.of(EmiPort.ordered(this.getName())));
        if (EmiUtil.showAdvancedTooltips()) {
            list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.literal(this.id.toString(), Formatting.DARK_GRAY))));
        }
        if (EmiConfig.appendModId) {
            list.add(TooltipComponent.of(EmiPort.ordered(EmiPort.literal(EmiUtil.getModName(this.getId().getResourceDomain()), Formatting.BLUE, Formatting.ITALIC))));
        }
        return list;
    }

    @ApiStatus.Experimental
    @Nullable
    public Comparator<EmiRecipe> getSort() {
        return this.sorter;
    }
}

