/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiFavorite;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.EntityPlayer;
import net.minecraft.GuiContainer;
import net.minecraft.InventoryPlayer;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import net.minecraft.Slot;
import org.jetbrains.annotations.ApiStatus;

public class EmiPlayerInventory {
    private final Comparison none = Comparison.DEFAULT_COMPARISON;
    private final Comparison nbt = Comparison.compareNbt();
    public Map<EmiStack, EmiStack> inventory = Maps.newHashMap();

    @Deprecated
    @ApiStatus.Internal
    public EmiPlayerInventory(EntityPlayer entity) {
        EmiRecipeHandler emiRecipeHandler;
        List handlers;
        GuiContainer screen = EmiApi.getHandledScreen();
        if (screen != null && screen.inventorySlots != null && !(handlers = EmiRecipeFiller.getAllHandlers(screen)).isEmpty() && (emiRecipeHandler = handlers.get(0)) instanceof StandardRecipeHandler) {
            StandardRecipeHandler standard = (StandardRecipeHandler)emiRecipeHandler;
            List<Slot> slots = standard.getInputSources(screen.inventorySlots);
            for (Slot slot : slots) {
                if (!slot.canTakeStack(entity)) continue;
                this.addStack(slot.getStack());
            }
            return;
        }
        InventoryPlayer pInv = entity.inventory;
        for (int i = 0; i < pInv.mainInventory.length; ++i) {
            this.addStack(pInv.mainInventory[i]);
        }
        if (pInv.getItemStack() != null) {
            this.addStack(pInv.getItemStack());
        }
    }

    public EmiPlayerInventory(List<EmiStack> stacks) {
        for (EmiStack stack : stacks) {
            this.addStack(stack);
        }
        ItemStack ci = Minecraft.getMinecraft().thePlayer.inventory.getItemStack();
        if (ci != null) {
            this.addStack(ci);
        }
    }

    public static EmiPlayerInventory of(EntityPlayer entity) {
        List handlers;
        GuiContainer screen = EmiApi.getHandledScreen();
        if (screen != null && !(handlers = EmiRecipeFiller.getAllHandlers(screen)).isEmpty()) {
            return handlers.get(0).getInventory(screen);
        }
        return new EmiPlayerInventory(entity);
    }

    private void addStack(ItemStack is) {
        EmiStack stack = EmiStack.of(is).comparison(c -> this.none);
        this.addStack(stack);
    }

    private void addStack(EmiStack stack) {
        if (!stack.isEmpty()) {
            this.inventory.merge(stack, stack, (a, b) -> a.setAmount(a.getAmount() + b.getAmount()));
        }
    }

    public Predicate<EmiRecipe> getPredicate() {
        GuiContainer screen = EmiApi.getHandledScreen();
        List handlers = EmiRecipeFiller.getAllHandlers(screen);
        if (!handlers.isEmpty()) {
            EmiCraftContext context = new EmiCraftContext(screen, this, EmiCraftContext.Type.CRAFTABLE);
            return r -> {
                for (EmiRecipeHandler handler : handlers) {
                    if (!handler.supportsRecipe((EmiRecipe)r)) continue;
                    return handler.canCraft((EmiRecipe)r, context);
                }
                return false;
            };
        }
        return null;
    }

    public List<EmiIngredient> getCraftables() {
        Predicate<EmiRecipe> predicate = this.getPredicate();
        if (predicate == null) {
            return Collections.emptyList();
        }
        HashSet set = Sets.newHashSet();
        for (EmiStack stack : this.inventory.keySet()) {
            set.addAll(EmiApi.getRecipeManager().getRecipesByInput(stack));
        }
        return set.stream().filter(r -> !r.hideCraftable() && predicate.test((EmiRecipe)r) && !r.getOutputs().isEmpty()).map(EmiFavorite.Craftable::new).sorted(Comparator.comparingInt(a -> EmiStackList.indices.getOrDefault((Object)a.getStack(), Integer.MAX_VALUE)).thenComparingLong(EmiFavorite::getAmount)).collect(Collectors.toList());
    }

    public List<Boolean> getCraftAvailability(EmiRecipe recipe) {
        Object2LongOpenHashMap used = new Object2LongOpenHashMap();
        ArrayList states = Lists.newArrayList();
        block0: for (EmiIngredient ingredient : recipe.getInputs()) {
            for (EmiStack stack : ingredient.getEmiStacks()) {
                long desired = stack.getAmount();
                if (!this.inventory.containsKey(stack)) continue;
                EmiStack identity = this.inventory.get(stack);
                long alreadyUsed = used.getOrDefault((Object)identity, 0L);
                long available = identity.getAmount() - alreadyUsed;
                if (available < desired) continue;
                used.put((Object)identity, desired + alreadyUsed);
                states.add(true);
                continue block0;
            }
            states.add(false);
        }
        return states;
    }

    public boolean canCraft(EmiRecipe recipe) {
        return this.canCraft(recipe, 1L);
    }

    public boolean canCraft(EmiRecipe recipe, long amount) {
        Object2LongOpenHashMap used = new Object2LongOpenHashMap();
        block0: for (EmiIngredient ingredient : recipe.getInputs()) {
            if (ingredient.isEmpty()) continue;
            for (EmiStack stack : ingredient.getEmiStacks()) {
                long desired = stack.getAmount() * amount;
                if (!this.inventory.containsKey(stack)) continue;
                EmiStack identity = this.inventory.get(stack);
                long alreadyUsed = used.getOrDefault((Object)identity, 0L);
                long available = identity.getAmount() - alreadyUsed;
                if (available < desired) continue;
                used.put((Object)identity, desired + alreadyUsed);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean isEqual(EmiPlayerInventory other) {
        if (other == null) {
            return false;
        }
        Comparison comparison = Comparison.of((EmiStack a, EmiStack b) -> this.nbt.compare(a, b) && a.getAmount() == b.getAmount());
        if (other.inventory.size() != this.inventory.size()) {
            return false;
        }
        for (EmiStack stack : this.inventory.keySet()) {
            if (other.inventory.containsKey(stack) && other.inventory.get(stack).isEqual(stack, comparison)) continue;
            return false;
        }
        return true;
    }
}

