/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.recipe;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.screen.tooltip.EmiSecondaryOutputComponent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moddedmite.emi.MITEPlugin;
import net.minecraft.Block;
import net.minecraft.ItemStack;
import net.minecraft.Material;
import net.minecraft.ResourceLocation;
import shims.java.com.unascribed.retroemi.ItemStacks;
import shims.java.net.minecraft.text.MutableText;

public class EmiCraftingRecipe
implements EmiRecipe {
    protected final ResourceLocation id;
    protected final List<EmiIngredient> input;
    protected final EmiStack output;
    public final boolean shapeless;
    public final ItemStack[] secondaryOutputs;
    private final float crafting_difficulty;

    public EmiCraftingRecipe(List<EmiIngredient> input, EmiStack output, ResourceLocation id, ItemStack[] secondaryOutputs, float craftingDifficulty) {
        this(input, output, id, true, secondaryOutputs, craftingDifficulty);
    }

    public EmiCraftingRecipe(List<EmiIngredient> input, EmiStack output, ResourceLocation id, boolean shapeless, ItemStack[] secondaryOutputs, float craftingDifficulty) {
        this.input = input;
        this.output = output;
        this.id = id;
        this.shapeless = shapeless;
        this.secondaryOutputs = secondaryOutputs;
        this.crafting_difficulty = craftingDifficulty;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.CRAFTING;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    @Override
    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> list = new ArrayList<EmiStack>(this.output.getEmiStacks());
        if (this.secondaryOutputs != null) {
            list.addAll(Arrays.stream(this.secondaryOutputs).map(EmiStack::of).toList());
        }
        return list;
    }

    @Override
    public int getDisplayWidth() {
        return 118;
    }

    @Override
    public int getDisplayHeight() {
        return 54;
    }

    public boolean canFit(int width, int height) {
        if (this.input.size() > 9) {
            return false;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            int x = i % 3;
            int y = i / 3;
            if (this.input.get(i).isEmpty() || x < width && y < height) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 18);
        if (this.shapeless) {
            widgets.addTexture(EmiTexture.SHAPELESS, 97, 0);
        }
        int sOff = 0;
        if (!this.shapeless) {
            if (this.canFit(1, 3)) {
                --sOff;
            }
            if (this.canFit(3, 1)) {
                sOff -= 3;
            }
        }
        for (int i = 0; i < 9; ++i) {
            int s = i + sOff;
            if (s >= 0 && s < this.input.size()) {
                widgets.addSlot(this.input.get(s), i % 3 * 18, i / 3 * 18);
                continue;
            }
            widgets.addSlot(EmiStack.of(ItemStacks.EMPTY), i % 3 * 18, i / 3 * 18);
        }
        if (this.secondaryOutputs != null) {
            widgets.addTexture(MITEPlugin.SMALL_PLUS, 84, 23).tooltip(List.of(new EmiSecondaryOutputComponent(this.secondaryOutputs)));
        }
        widgets.addSlot(this.output, 92, 14).large(true).recipeContext(this);
        if (EmiConfig.MITECraftInfo) {
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            float crafting_time = (float)((Math.pow(this.crafting_difficulty - 100.0f, 0.74) + 100.0) / 20.0);
            widgets.addText(EmiPort.translatable("emi.craft_difficult.items", String.format("%s", decimalFormat.format(this.crafting_difficulty))), 55, 45, -1, true);
            widgets.addText(EmiPort.translatable("emi.craft_time.items", String.format("%s", decimalFormat.format(crafting_time))), 55, 35, -1, true);
            if (!Block.workbench.isValidMetadata(2) || this.getCraftLevel() == null || this.getCraftLevel() == Material.air || this.getCraftLevel() == Material.rusted_iron || this.getCraftLevel() == Material.wood) {
                return;
            }
            MutableText materialName = EmiPort.literal(this.getCraftLevel().getLocalizedName());
            widgets.addText(EmiPort.translatable("emi.craft_level.items", materialName), 55, 0, -1, true);
        }
    }
}

